/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ListPortfoliosRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListPortfoliosRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageToken").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").isBinary(false).build();
    private static final ListPortfoliosRequestModelMarshaller INSTANCE = new ListPortfoliosRequestModelMarshaller();

    private ListPortfoliosRequestModelMarshaller() {
    }

    public static ListPortfoliosRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListPortfoliosRequest listPortfoliosRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listPortfoliosRequest), (String)"listPortfoliosRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listPortfoliosRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)listPortfoliosRequest.pageToken(), PAGETOKEN_BINDING);
            protocolMarshaller.marshall((Object)listPortfoliosRequest.pageSize(), PAGESIZE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

