/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.servicecatalog.model.CreateProductRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateProductRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").isBinary(false).build();
    private static final MarshallingInfo<String> DISTRIBUTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Distributor").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportDescription").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportEmail").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportUrl").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductType").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> PROVISIONINGARTIFACTPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactParameters").isBinary(false).build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final CreateProductRequestModelMarshaller INSTANCE = new CreateProductRequestModelMarshaller();

    private CreateProductRequestModelMarshaller() {
    }

    public static CreateProductRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateProductRequest createProductRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createProductRequest), (String)"createProductRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createProductRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.distributor(), DISTRIBUTOR_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.supportDescription(), SUPPORTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.supportEmail(), SUPPORTEMAIL_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.supportUrl(), SUPPORTURL_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.productTypeString(), PRODUCTTYPE_BINDING);
            protocolMarshaller.marshall(createProductRequest.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.provisioningArtifactParameters(), PROVISIONINGARTIFACTPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)createProductRequest.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

