/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactInfoCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisioningArtifactType;
import software.amazon.awssdk.services.servicecatalog.transform.ProvisioningArtifactPropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ProvisioningArtifactProperties
implements StructuredPojo,
ToCopyableBuilder<Builder, ProvisioningArtifactProperties> {
    private final String name;
    private final String description;
    private final Map<String, String> info;
    private final String type;

    private ProvisioningArtifactProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.info = builder.info;
        this.type = builder.type;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Map<String, String> info() {
        return this.info;
    }

    public ProvisioningArtifactType type() {
        return ProvisioningArtifactType.fromValue(this.type);
    }

    public String typeString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.info());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvisioningArtifactProperties)) {
            return false;
        }
        ProvisioningArtifactProperties other = (ProvisioningArtifactProperties)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.info(), other.info()) && Objects.equals(this.typeString(), other.typeString());
    }

    public String toString() {
        return ToString.builder((String)"ProvisioningArtifactProperties").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Info", this.info()).add("Type", (Object)this.typeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Info": {
                return Optional.of(clazz.cast(this.info()));
            }
            case "Type": {
                return Optional.of(clazz.cast(this.typeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProvisioningArtifactPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> info;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvisioningArtifactProperties model) {
            this.name(model.name);
            this.description(model.description);
            this.info(model.info);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Map<String, String> getInfo() {
            return this.info;
        }

        @Override
        public final Builder info(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
            return this;
        }

        public final void setInfo(Map<String, String> info) {
            this.info = ProvisioningArtifactInfoCopier.copy(info);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ProvisioningArtifactType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public ProvisioningArtifactProperties build() {
            return new ProvisioningArtifactProperties(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ProvisioningArtifactProperties> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder info(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(ProvisioningArtifactType var1);
    }
}

