/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogClient;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListConstraintsForPortfolioResponse;

public final class ListConstraintsForPortfolioPaginator
implements SdkIterable<ListConstraintsForPortfolioResponse> {
    private final ServiceCatalogClient client;
    private final ListConstraintsForPortfolioRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListConstraintsForPortfolioPaginator(ServiceCatalogClient client, ListConstraintsForPortfolioRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListConstraintsForPortfolioResponseFetcher();
    }

    public Iterator<ListConstraintsForPortfolioResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    private class ListConstraintsForPortfolioResponseFetcher
    implements NextPageFetcher<ListConstraintsForPortfolioResponse> {
        private ListConstraintsForPortfolioResponseFetcher() {
        }

        public boolean hasNextPage(ListConstraintsForPortfolioResponse previousPage) {
            return previousPage.nextPageToken() != null;
        }

        public ListConstraintsForPortfolioResponse nextPage(ListConstraintsForPortfolioResponse previousPage) {
            if (previousPage == null) {
                return ListConstraintsForPortfolioPaginator.this.client.listConstraintsForPortfolio(ListConstraintsForPortfolioPaginator.this.firstRequest);
            }
            return ListConstraintsForPortfolioPaginator.this.client.listConstraintsForPortfolio((ListConstraintsForPortfolioRequest)((Object)ListConstraintsForPortfolioPaginator.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

