/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.AllowedValuesCopier;
import software.amazon.awssdk.services.servicecatalog.transform.ParameterConstraintsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ParameterConstraints
implements StructuredPojo,
ToCopyableBuilder<Builder, ParameterConstraints> {
    private final List<String> allowedValues;

    private ParameterConstraints(BuilderImpl builder) {
        this.allowedValues = builder.allowedValues;
    }

    public List<String> allowedValues() {
        return this.allowedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterConstraints)) {
            return false;
        }
        ParameterConstraints other = (ParameterConstraints)obj;
        return Objects.equals(this.allowedValues(), other.allowedValues());
    }

    public String toString() {
        return ToString.builder((String)"ParameterConstraints").add("AllowedValues", this.allowedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AllowedValues": {
                return Optional.of(clazz.cast(this.allowedValues()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ParameterConstraintsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterConstraints model) {
            this.allowedValues(model.allowedValues);
        }

        public final Collection<String> getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = AllowedValuesCopier.copy(allowedValues);
        }

        public ParameterConstraints build() {
            return new ParameterConstraints(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ParameterConstraints> {
        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);
    }
}

