/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.servicecatalog.model.AddTagsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.services.servicecatalog.model.Tag;
import software.amazon.awssdk.services.servicecatalog.model.TagKeysCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateProductRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, UpdateProductRequest> {
    private final String acceptLanguage;
    private final String id;
    private final String name;
    private final String owner;
    private final String description;
    private final String distributor;
    private final String supportDescription;
    private final String supportEmail;
    private final String supportUrl;
    private final List<Tag> addTags;
    private final List<String> removeTags;

    private UpdateProductRequest(BuilderImpl builder) {
        super(builder);
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.name = builder.name;
        this.owner = builder.owner;
        this.description = builder.description;
        this.distributor = builder.distributor;
        this.supportDescription = builder.supportDescription;
        this.supportEmail = builder.supportEmail;
        this.supportUrl = builder.supportUrl;
        this.addTags = builder.addTags;
        this.removeTags = builder.removeTags;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String owner() {
        return this.owner;
    }

    public String description() {
        return this.description;
    }

    public String distributor() {
        return this.distributor;
    }

    public String supportDescription() {
        return this.supportDescription;
    }

    public String supportEmail() {
        return this.supportEmail;
    }

    public String supportUrl() {
        return this.supportUrl;
    }

    public List<Tag> addTags() {
        return this.addTags;
    }

    public List<String> removeTags() {
        return this.removeTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributor());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportEmail());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.addTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeTags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProductRequest)) {
            return false;
        }
        UpdateProductRequest other = (UpdateProductRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.distributor(), other.distributor()) && Objects.equals(this.supportDescription(), other.supportDescription()) && Objects.equals(this.supportEmail(), other.supportEmail()) && Objects.equals(this.supportUrl(), other.supportUrl()) && Objects.equals(this.addTags(), other.addTags()) && Objects.equals(this.removeTags(), other.removeTags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.owner() != null) {
            sb.append("Owner: ").append(this.owner()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.distributor() != null) {
            sb.append("Distributor: ").append(this.distributor()).append(",");
        }
        if (this.supportDescription() != null) {
            sb.append("SupportDescription: ").append(this.supportDescription()).append(",");
        }
        if (this.supportEmail() != null) {
            sb.append("SupportEmail: ").append(this.supportEmail()).append(",");
        }
        if (this.supportUrl() != null) {
            sb.append("SupportUrl: ").append(this.supportUrl()).append(",");
        }
        if (this.addTags() != null) {
            sb.append("AddTags: ").append(this.addTags()).append(",");
        }
        if (this.removeTags() != null) {
            sb.append("RemoveTags: ").append(this.removeTags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Owner": {
                return Optional.of(clazz.cast(this.owner()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Distributor": {
                return Optional.of(clazz.cast(this.distributor()));
            }
            case "SupportDescription": {
                return Optional.of(clazz.cast(this.supportDescription()));
            }
            case "SupportEmail": {
                return Optional.of(clazz.cast(this.supportEmail()));
            }
            case "SupportUrl": {
                return Optional.of(clazz.cast(this.supportUrl()));
            }
            case "AddTags": {
                return Optional.of(clazz.cast(this.addTags()));
            }
            case "RemoveTags": {
                return Optional.of(clazz.cast(this.removeTags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String name;
        private String owner;
        private String description;
        private String distributor;
        private String supportDescription;
        private String supportEmail;
        private String supportUrl;
        private List<Tag> addTags;
        private List<String> removeTags;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProductRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.id(model.id);
            this.name(model.name);
            this.owner(model.owner);
            this.description(model.description);
            this.distributor(model.distributor);
            this.supportDescription(model.supportDescription);
            this.supportEmail(model.supportEmail);
            this.supportUrl(model.supportUrl);
            this.addTags(model.addTags);
            this.removeTags(model.removeTags);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getOwner() {
            return this.owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDistributor() {
            return this.distributor;
        }

        @Override
        public final Builder distributor(String distributor) {
            this.distributor = distributor;
            return this;
        }

        public final void setDistributor(String distributor) {
            this.distributor = distributor;
        }

        public final String getSupportDescription() {
            return this.supportDescription;
        }

        @Override
        public final Builder supportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
            return this;
        }

        public final void setSupportDescription(String supportDescription) {
            this.supportDescription = supportDescription;
        }

        public final String getSupportEmail() {
            return this.supportEmail;
        }

        @Override
        public final Builder supportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
            return this;
        }

        public final void setSupportEmail(String supportEmail) {
            this.supportEmail = supportEmail;
        }

        public final String getSupportUrl() {
            return this.supportUrl;
        }

        @Override
        public final Builder supportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
            return this;
        }

        public final void setSupportUrl(String supportUrl) {
            this.supportUrl = supportUrl;
        }

        public final Collection<Tag.Builder> getAddTags() {
            return this.addTags != null ? (Collection)this.addTags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addTags(Collection<Tag> addTags) {
            this.addTags = AddTagsCopier.copy(addTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addTags(Tag ... addTags) {
            this.addTags(Arrays.asList(addTags));
            return this;
        }

        public final void setAddTags(Collection<Tag.BuilderImpl> addTags) {
            this.addTags = AddTagsCopier.copyFromBuilder(addTags);
        }

        public final Collection<String> getRemoveTags() {
            return this.removeTags;
        }

        @Override
        public final Builder removeTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeTags(String ... removeTags) {
            this.removeTags(Arrays.asList(removeTags));
            return this;
        }

        public final void setRemoveTags(Collection<String> removeTags) {
            this.removeTags = TagKeysCopier.copy(removeTags);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateProductRequest build() {
            return new UpdateProductRequest(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    CopyableBuilder<Builder, UpdateProductRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder distributor(String var1);

        public Builder supportDescription(String var1);

        public Builder supportEmail(String var1);

        public Builder supportUrl(String var1);

        public Builder addTags(Collection<Tag> var1);

        public Builder addTags(Tag ... var1);

        public Builder removeTags(Collection<String> var1);

        public Builder removeTags(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

