/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationValue;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewAggregationsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, SearchProductsResponse> {
    private final List<ProductViewSummary> productViewSummaries;
    private final Map<String, List<ProductViewAggregationValue>> productViewAggregations;
    private final String nextPageToken;

    private SearchProductsResponse(BuilderImpl builder) {
        super(builder);
        this.productViewSummaries = builder.productViewSummaries;
        this.productViewAggregations = builder.productViewAggregations;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProductViewSummary> productViewSummaries() {
        return this.productViewSummaries;
    }

    public Map<String, List<ProductViewAggregationValue>> productViewAggregations() {
        return this.productViewAggregations;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewSummaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.productViewAggregations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsResponse)) {
            return false;
        }
        SearchProductsResponse other = (SearchProductsResponse)((Object)obj);
        return Objects.equals(this.productViewSummaries(), other.productViewSummaries()) && Objects.equals(this.productViewAggregations(), other.productViewAggregations()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.productViewSummaries() != null) {
            sb.append("ProductViewSummaries: ").append(this.productViewSummaries()).append(",");
        }
        if (this.productViewAggregations() != null) {
            sb.append("ProductViewAggregations: ").append(this.productViewAggregations()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductViewSummaries": {
                return Optional.of(clazz.cast(this.productViewSummaries()));
            }
            case "ProductViewAggregations": {
                return Optional.of(clazz.cast(this.productViewAggregations()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProductViewSummary> productViewSummaries;
        private Map<String, List<ProductViewAggregationValue>> productViewAggregations;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsResponse model) {
            this.productViewSummaries(model.productViewSummaries);
            this.productViewAggregations(model.productViewAggregations);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProductViewSummary.Builder> getProductViewSummaries() {
            return this.productViewSummaries != null ? (Collection)this.productViewSummaries.stream().map(ProductViewSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder productViewSummaries(Collection<ProductViewSummary> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copy(productViewSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productViewSummaries(ProductViewSummary ... productViewSummaries) {
            this.productViewSummaries(Arrays.asList(productViewSummaries));
            return this;
        }

        public final void setProductViewSummaries(Collection<ProductViewSummary.BuilderImpl> productViewSummaries) {
            this.productViewSummaries = ProductViewSummariesCopier.copyFromBuilder(productViewSummaries);
        }

        public final Map<String, ? extends Collection<ProductViewAggregationValue>> getProductViewAggregations() {
            return this.productViewAggregations;
        }

        @Override
        public final Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
            return this;
        }

        public final void setProductViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> productViewAggregations) {
            this.productViewAggregations = ProductViewAggregationsCopier.copy(productViewAggregations);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProductsResponse build() {
            return new SearchProductsResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, SearchProductsResponse> {
        public Builder productViewSummaries(Collection<ProductViewSummary> var1);

        public Builder productViewSummaries(ProductViewSummary ... var1);

        public Builder productViewAggregations(Map<String, ? extends Collection<ProductViewAggregationValue>> var1);

        public Builder nextPageToken(String var1);
    }
}

