/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.servicecatalog.model.RecordDetail;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutputsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRecordResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeRecordResponse> {
    private final RecordDetail recordDetail;
    private final List<RecordOutput> recordOutputs;
    private final String nextPageToken;

    private DescribeRecordResponse(BuilderImpl builder) {
        super(builder);
        this.recordDetail = builder.recordDetail;
        this.recordOutputs = builder.recordOutputs;
        this.nextPageToken = builder.nextPageToken;
    }

    public RecordDetail recordDetail() {
        return this.recordDetail;
    }

    public List<RecordOutput> recordOutputs() {
        return this.recordOutputs;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordOutputs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecordResponse)) {
            return false;
        }
        DescribeRecordResponse other = (DescribeRecordResponse)((Object)obj);
        return Objects.equals(this.recordDetail(), other.recordDetail()) && Objects.equals(this.recordOutputs(), other.recordOutputs()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.recordDetail() != null) {
            sb.append("RecordDetail: ").append(this.recordDetail()).append(",");
        }
        if (this.recordOutputs() != null) {
            sb.append("RecordOutputs: ").append(this.recordOutputs()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecordDetail": {
                return Optional.of(clazz.cast(this.recordDetail()));
            }
            case "RecordOutputs": {
                return Optional.of(clazz.cast(this.recordOutputs()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private RecordDetail recordDetail;
        private List<RecordOutput> recordOutputs;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecordResponse model) {
            this.recordDetail(model.recordDetail);
            this.recordOutputs(model.recordOutputs);
            this.nextPageToken(model.nextPageToken);
        }

        public final RecordDetail.Builder getRecordDetail() {
            return this.recordDetail != null ? this.recordDetail.toBuilder() : null;
        }

        @Override
        public final Builder recordDetail(RecordDetail recordDetail) {
            this.recordDetail = recordDetail;
            return this;
        }

        public final void setRecordDetail(RecordDetail.BuilderImpl recordDetail) {
            this.recordDetail = recordDetail != null ? recordDetail.build() : null;
        }

        public final Collection<RecordOutput.Builder> getRecordOutputs() {
            return this.recordOutputs != null ? (Collection)this.recordOutputs.stream().map(RecordOutput::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recordOutputs(Collection<RecordOutput> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copy(recordOutputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recordOutputs(RecordOutput ... recordOutputs) {
            this.recordOutputs(Arrays.asList(recordOutputs));
            return this;
        }

        public final void setRecordOutputs(Collection<RecordOutput.BuilderImpl> recordOutputs) {
            this.recordOutputs = RecordOutputsCopier.copyFromBuilder(recordOutputs);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public DescribeRecordResponse build() {
            return new DescribeRecordResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, DescribeRecordResponse> {
        public Builder recordDetail(RecordDetail var1);

        default public Builder recordDetail(Consumer<RecordDetail.Builder> recordDetail) {
            return this.recordDetail((RecordDetail)((RecordDetail.Builder)RecordDetail.builder().apply(recordDetail)).build());
        }

        public Builder recordOutputs(Collection<RecordOutput> var1);

        public Builder recordOutputs(RecordOutput ... var1);

        public Builder nextPageToken(String var1);
    }
}

