/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.servicecatalog.model.CopyProductRequest;

@SdkInternalApi
public class CopyProductRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").build();
    private static final MarshallingInfo<String> SOURCEPRODUCTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceProductArn").build();
    private static final MarshallingInfo<String> TARGETPRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetProductId").build();
    private static final MarshallingInfo<String> TARGETPRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TargetProductName").build();
    private static final MarshallingInfo<List> SOURCEPROVISIONINGARTIFACTIDENTIFIERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SourceProvisioningArtifactIdentifiers").build();
    private static final MarshallingInfo<List> COPYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CopyOptions").build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final CopyProductRequestModelMarshaller INSTANCE = new CopyProductRequestModelMarshaller();

    public static CopyProductRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CopyProductRequest copyProductRequest, ProtocolMarshaller protocolMarshaller) {
        if (copyProductRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)copyProductRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)copyProductRequest.sourceProductArn(), SOURCEPRODUCTARN_BINDING);
            protocolMarshaller.marshall((Object)copyProductRequest.targetProductId(), TARGETPRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)copyProductRequest.targetProductName(), TARGETPRODUCTNAME_BINDING);
            protocolMarshaller.marshall(copyProductRequest.sourceProvisioningArtifactIdentifiers(), SOURCEPROVISIONINGARTIFACTIDENTIFIERS_BINDING);
            protocolMarshaller.marshall(copyProductRequest.copyOptionsStrings(), COPYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)copyProductRequest.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

