/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.servicecatalog.model.ProductSource;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFilterBy;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewFiltersCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSortBy;
import software.amazon.awssdk.services.servicecatalog.model.SortOrder;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchProductsAsAdminRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SearchProductsAsAdminRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final Map<String, List<String>> filters;
    private final String sortBy;
    private final String sortOrder;
    private final String pageToken;
    private final Integer pageSize;
    private final String productSource;

    private SearchProductsAsAdminRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.filters = builder.filters;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
        this.productSource = builder.productSource;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public Map<ProductViewFilterBy, List<String>> filters() {
        return TypeConverter.convert(this.filters, ProductViewFilterBy::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)ProductViewFilterBy.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, List<String>> filtersStrings() {
        return this.filters;
    }

    public ProductViewSortBy sortBy() {
        return ProductViewSortBy.fromValue(this.sortBy);
    }

    public String sortByString() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderString() {
        return this.sortOrder;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public ProductSource productSource() {
        return ProductSource.fromValue(this.productSource);
    }

    public String productSourceString() {
        return this.productSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.acceptLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(this.portfolioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filtersStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.productSourceString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProductsAsAdminRequest)) {
            return false;
        }
        SearchProductsAsAdminRequest other = (SearchProductsAsAdminRequest)((Object)obj);
        return Objects.equals(this.acceptLanguage(), other.acceptLanguage()) && Objects.equals(this.portfolioId(), other.portfolioId()) && Objects.equals(this.filtersStrings(), other.filtersStrings()) && Objects.equals(this.sortByString(), other.sortByString()) && Objects.equals(this.sortOrderString(), other.sortOrderString()) && Objects.equals(this.pageToken(), other.pageToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.productSourceString(), other.productSourceString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        if (this.filtersStrings() != null) {
            sb.append("Filters: ").append(this.filtersStrings()).append(",");
        }
        if (this.sortByString() != null) {
            sb.append("SortBy: ").append(this.sortByString()).append(",");
        }
        if (this.sortOrderString() != null) {
            sb.append("SortOrder: ").append(this.sortOrderString()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.productSourceString() != null) {
            sb.append("ProductSource: ").append(this.productSourceString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AcceptLanguage": {
                return Optional.of(clazz.cast(this.acceptLanguage()));
            }
            case "PortfolioId": {
                return Optional.of(clazz.cast(this.portfolioId()));
            }
            case "Filters": {
                return Optional.of(clazz.cast(this.filtersStrings()));
            }
            case "SortBy": {
                return Optional.of(clazz.cast(this.sortByString()));
            }
            case "SortOrder": {
                return Optional.of(clazz.cast(this.sortOrderString()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "ProductSource": {
                return Optional.of(clazz.cast(this.productSourceString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private Map<String, List<String>> filters;
        private String sortBy;
        private String sortOrder;
        private String pageToken;
        private Integer pageSize;
        private String productSource;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProductsAsAdminRequest model) {
            this.acceptLanguage(model.acceptLanguage);
            this.portfolioId(model.portfolioId);
            this.filters(model.filters);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.pageToken(model.pageToken);
            this.pageSize(model.pageSize);
            this.productSource(model.productSource);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final Map<String, ? extends Collection<String>> getFilters() {
            return this.filters;
        }

        @Override
        public final Builder filters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
            return this;
        }

        public final void setFilters(Map<String, ? extends Collection<String>> filters) {
            this.filters = ProductViewFiltersCopier.copy(filters);
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ProductViewSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getProductSource() {
            return this.productSource;
        }

        @Override
        public final Builder productSource(String productSource) {
            this.productSource = productSource;
            return this;
        }

        @Override
        public final Builder productSource(ProductSource productSource) {
            this.productSource(productSource.toString());
            return this;
        }

        public final void setProductSource(String productSource) {
            this.productSource = productSource;
        }

        public SearchProductsAsAdminRequest build() {
            return new SearchProductsAsAdminRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SearchProductsAsAdminRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder filters(Map<String, ? extends Collection<String>> var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ProductViewSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder productSource(String var1);

        public Builder productSource(ProductSource var1);
    }
}

