/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListResourcesForTagOptionRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListResourcesForTagOptionRequest> {
    private final String tagOptionId;
    private final String resourceType;
    private final Integer pageSize;
    private final String pageToken;

    private ListResourcesForTagOptionRequest(BuilderImpl builder) {
        this.tagOptionId = builder.tagOptionId;
        this.resourceType = builder.resourceType;
        this.pageSize = builder.pageSize;
        this.pageToken = builder.pageToken;
    }

    public String tagOptionId() {
        return this.tagOptionId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourcesForTagOptionRequest)) {
            return false;
        }
        ListResourcesForTagOptionRequest other = (ListResourcesForTagOptionRequest)((Object)obj);
        return Objects.equals(this.tagOptionId(), other.tagOptionId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.pageToken(), other.pageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.tagOptionId() != null) {
            sb.append("TagOptionId: ").append(this.tagOptionId()).append(",");
        }
        if (this.resourceType() != null) {
            sb.append("ResourceType: ").append(this.resourceType()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TagOptionId": {
                return Optional.of(clazz.cast(this.tagOptionId()));
            }
            case "ResourceType": {
                return Optional.of(clazz.cast(this.resourceType()));
            }
            case "PageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "PageToken": {
                return Optional.of(clazz.cast(this.pageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String tagOptionId;
        private String resourceType;
        private Integer pageSize;
        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourcesForTagOptionRequest model) {
            this.tagOptionId(model.tagOptionId);
            this.resourceType(model.resourceType);
            this.pageSize(model.pageSize);
            this.pageToken(model.pageToken);
        }

        public final String getTagOptionId() {
            return this.tagOptionId;
        }

        @Override
        public final Builder tagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
            return this;
        }

        public final void setTagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public ListResourcesForTagOptionRequest build() {
            return new ListResourcesForTagOptionRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListResourcesForTagOptionRequest> {
        public Builder tagOptionId(String var1);

        public Builder resourceType(String var1);

        public Builder pageSize(Integer var1);

        public Builder pageToken(String var1);
    }
}

