/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.AccountIdsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPortfolioAccessResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListPortfolioAccessResponse> {
    private final List<String> accountIds;
    private final String nextPageToken;

    private ListPortfolioAccessResponse(BuilderImpl builder) {
        this.accountIds = builder.accountIds;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<String> accountIds() {
        return this.accountIds;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortfolioAccessResponse)) {
            return false;
        }
        ListPortfolioAccessResponse other = (ListPortfolioAccessResponse)((Object)obj);
        return Objects.equals(this.accountIds(), other.accountIds()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.accountIds() != null) {
            sb.append("AccountIds: ").append(this.accountIds()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountIds": {
                return Optional.of(clazz.cast(this.accountIds()));
            }
            case "NextPageToken": {
                return Optional.of(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> accountIds;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortfolioAccessResponse model) {
            this.accountIds(model.accountIds);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<String> getAccountIds() {
            return this.accountIds;
        }

        @Override
        public final Builder accountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountIds(String ... accountIds) {
            this.accountIds(Arrays.asList(accountIds));
            return this;
        }

        public final void setAccountIds(Collection<String> accountIds) {
            this.accountIds = AccountIdsCopier.copy(accountIds);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListPortfolioAccessResponse build() {
            return new ListPortfolioAccessResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListPortfolioAccessResponse> {
        public Builder accountIds(Collection<String> var1);

        public Builder accountIds(String ... var1);

        public Builder nextPageToken(String var1);
    }
}

