/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssociateTagOptionWithResourceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, AssociateTagOptionWithResourceRequest> {
    private final String resourceId;
    private final String tagOptionId;

    private AssociateTagOptionWithResourceRequest(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.tagOptionId = builder.tagOptionId;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String tagOptionId() {
        return this.tagOptionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagOptionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateTagOptionWithResourceRequest)) {
            return false;
        }
        AssociateTagOptionWithResourceRequest other = (AssociateTagOptionWithResourceRequest)((Object)obj);
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.tagOptionId(), other.tagOptionId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.resourceId() != null) {
            sb.append("ResourceId: ").append(this.resourceId()).append(",");
        }
        if (this.tagOptionId() != null) {
            sb.append("TagOptionId: ").append(this.tagOptionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.of(clazz.cast(this.resourceId()));
            }
            case "TagOptionId": {
                return Optional.of(clazz.cast(this.tagOptionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String tagOptionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateTagOptionWithResourceRequest model) {
            this.resourceId(model.resourceId);
            this.tagOptionId(model.tagOptionId);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getTagOptionId() {
            return this.tagOptionId;
        }

        @Override
        public final Builder tagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
            return this;
        }

        public final void setTagOptionId(String tagOptionId) {
            this.tagOptionId = tagOptionId;
        }

        public AssociateTagOptionWithResourceRequest build() {
            return new AssociateTagOptionWithResourceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AssociateTagOptionWithResourceRequest> {
        public Builder resourceId(String var1);

        public Builder tagOptionId(String var1);
    }
}

