/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetail;
import software.amazon.awssdk.services.servicecatalog.model.ConstraintDetailsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListConstraintsForPortfolioResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
    private final List<ConstraintDetail> constraintDetails;
    private final String nextPageToken;

    private ListConstraintsForPortfolioResponse(BuilderImpl builder) {
        this.constraintDetails = builder.constraintDetails;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ConstraintDetail> constraintDetails() {
        return this.constraintDetails;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.constraintDetails() == null ? 0 : this.constraintDetails().hashCode());
        hashCode = 31 * hashCode + (this.nextPageToken() == null ? 0 : this.nextPageToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConstraintsForPortfolioResponse)) {
            return false;
        }
        ListConstraintsForPortfolioResponse other = (ListConstraintsForPortfolioResponse)((Object)obj);
        if (other.constraintDetails() == null ^ this.constraintDetails() == null) {
            return false;
        }
        if (other.constraintDetails() != null && !other.constraintDetails().equals(this.constraintDetails())) {
            return false;
        }
        if (other.nextPageToken() == null ^ this.nextPageToken() == null) {
            return false;
        }
        return other.nextPageToken() == null || other.nextPageToken().equals(this.nextPageToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.constraintDetails() != null) {
            sb.append("ConstraintDetails: ").append(this.constraintDetails()).append(",");
        }
        if (this.nextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.nextPageToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ConstraintDetail> constraintDetails;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConstraintsForPortfolioResponse model) {
            this.setConstraintDetails(model.constraintDetails);
            this.setNextPageToken(model.nextPageToken);
        }

        public final Collection<ConstraintDetail> getConstraintDetails() {
            return this.constraintDetails;
        }

        @Override
        public final Builder constraintDetails(Collection<ConstraintDetail> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copy(constraintDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder constraintDetails(ConstraintDetail ... constraintDetails) {
            this.constraintDetails(Arrays.asList(constraintDetails));
            return this;
        }

        public final void setConstraintDetails(Collection<ConstraintDetail> constraintDetails) {
            this.constraintDetails = ConstraintDetailsCopier.copy(constraintDetails);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public ListConstraintsForPortfolioResponse build() {
            return new ListConstraintsForPortfolioResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListConstraintsForPortfolioResponse> {
        public Builder constraintDetails(Collection<ConstraintDetail> var1);

        public Builder constraintDetails(ConstraintDetail ... var1);

        public Builder nextPageToken(String var1);
    }
}

