/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary;
import software.amazon.awssdk.services.servicecatalog.transform.ConstraintSummaryUnmarshaller;
import software.amazon.awssdk.services.servicecatalog.transform.TagUnmarshaller;

public class LaunchPathSummaryUnmarshaller
implements Unmarshaller<LaunchPathSummary, JsonUnmarshallerContext> {
    private static final LaunchPathSummaryUnmarshaller INSTANCE = new LaunchPathSummaryUnmarshaller();

    public LaunchPathSummary unmarshall(JsonUnmarshallerContext context) throws Exception {
        LaunchPathSummary.Builder launchPathSummaryBuilder = LaunchPathSummary.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Id", targetDepth)) {
                    context.nextToken();
                    launchPathSummaryBuilder.id((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ConstraintSummaries", targetDepth)) {
                    context.nextToken();
                    launchPathSummaryBuilder.constraintSummaries(new ListUnmarshaller((Unmarshaller)ConstraintSummaryUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Tags", targetDepth)) {
                    context.nextToken();
                    launchPathSummaryBuilder.tags(new ListUnmarshaller((Unmarshaller)TagUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    launchPathSummaryBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LaunchPathSummary)launchPathSummaryBuilder.build();
    }

    public static LaunchPathSummaryUnmarshaller getInstance() {
        return INSTANCE;
    }
}

