/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRecordRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRecordRequest> {
    private final String acceptLanguage;
    private final String id;
    private final String pageToken;
    private final Integer pageSize;

    private DescribeRecordRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.id = builder.id;
        this.pageToken = builder.pageToken;
        this.pageSize = builder.pageSize;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String id() {
        return this.id;
    }

    public String pageToken() {
        return this.pageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.id() == null ? 0 : this.id().hashCode());
        hashCode = 31 * hashCode + (this.pageToken() == null ? 0 : this.pageToken().hashCode());
        hashCode = 31 * hashCode + (this.pageSize() == null ? 0 : this.pageSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecordRequest)) {
            return false;
        }
        DescribeRecordRequest other = (DescribeRecordRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.id() == null ^ this.id() == null) {
            return false;
        }
        if (other.id() != null && !other.id().equals(this.id())) {
            return false;
        }
        if (other.pageToken() == null ^ this.pageToken() == null) {
            return false;
        }
        if (other.pageToken() != null && !other.pageToken().equals(this.pageToken())) {
            return false;
        }
        if (other.pageSize() == null ^ this.pageSize() == null) {
            return false;
        }
        return other.pageSize() == null || other.pageSize().equals(this.pageSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.id() != null) {
            sb.append("Id: ").append(this.id()).append(",");
        }
        if (this.pageToken() != null) {
            sb.append("PageToken: ").append(this.pageToken()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String id;
        private String pageToken;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecordRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setId(model.id);
            this.setPageToken(model.pageToken);
            this.setPageSize(model.pageSize);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getPageToken() {
            return this.pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public DescribeRecordRequest build() {
            return new DescribeRecordRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRecordRequest> {
        public Builder acceptLanguage(String var1);

        public Builder id(String var1);

        public Builder pageToken(String var1);

        public Builder pageSize(Integer var1);
    }
}

