/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateConstraintRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateConstraintRequest> {
    private final String acceptLanguage;
    private final String portfolioId;
    private final String productId;
    private final String parameters;
    private final String type;
    private final String description;
    private final String idempotencyToken;

    private CreateConstraintRequest(BuilderImpl builder) {
        this.acceptLanguage = builder.acceptLanguage;
        this.portfolioId = builder.portfolioId;
        this.productId = builder.productId;
        this.parameters = builder.parameters;
        this.type = builder.type;
        this.description = builder.description;
        this.idempotencyToken = builder.idempotencyToken;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public String portfolioId() {
        return this.portfolioId;
    }

    public String productId() {
        return this.productId;
    }

    public String parameters() {
        return this.parameters;
    }

    public String type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String idempotencyToken() {
        return this.idempotencyToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.acceptLanguage() == null ? 0 : this.acceptLanguage().hashCode());
        hashCode = 31 * hashCode + (this.portfolioId() == null ? 0 : this.portfolioId().hashCode());
        hashCode = 31 * hashCode + (this.productId() == null ? 0 : this.productId().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.idempotencyToken() == null ? 0 : this.idempotencyToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConstraintRequest)) {
            return false;
        }
        CreateConstraintRequest other = (CreateConstraintRequest)((Object)obj);
        if (other.acceptLanguage() == null ^ this.acceptLanguage() == null) {
            return false;
        }
        if (other.acceptLanguage() != null && !other.acceptLanguage().equals(this.acceptLanguage())) {
            return false;
        }
        if (other.portfolioId() == null ^ this.portfolioId() == null) {
            return false;
        }
        if (other.portfolioId() != null && !other.portfolioId().equals(this.portfolioId())) {
            return false;
        }
        if (other.productId() == null ^ this.productId() == null) {
            return false;
        }
        if (other.productId() != null && !other.productId().equals(this.productId())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.idempotencyToken() == null ^ this.idempotencyToken() == null) {
            return false;
        }
        return other.idempotencyToken() == null || other.idempotencyToken().equals(this.idempotencyToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acceptLanguage() != null) {
            sb.append("AcceptLanguage: ").append(this.acceptLanguage()).append(",");
        }
        if (this.portfolioId() != null) {
            sb.append("PortfolioId: ").append(this.portfolioId()).append(",");
        }
        if (this.productId() != null) {
            sb.append("ProductId: ").append(this.productId()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.idempotencyToken() != null) {
            sb.append("IdempotencyToken: ").append(this.idempotencyToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String acceptLanguage;
        private String portfolioId;
        private String productId;
        private String parameters;
        private String type;
        private String description;
        private String idempotencyToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConstraintRequest model) {
            this.setAcceptLanguage(model.acceptLanguage);
            this.setPortfolioId(model.portfolioId);
            this.setProductId(model.productId);
            this.setParameters(model.parameters);
            this.setType(model.type);
            this.setDescription(model.description);
            this.setIdempotencyToken(model.idempotencyToken);
        }

        public final String getAcceptLanguage() {
            return this.acceptLanguage;
        }

        @Override
        public final Builder acceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
            return this;
        }

        public final void setAcceptLanguage(String acceptLanguage) {
            this.acceptLanguage = acceptLanguage;
        }

        public final String getPortfolioId() {
            return this.portfolioId;
        }

        @Override
        public final Builder portfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
            return this;
        }

        public final void setPortfolioId(String portfolioId) {
            this.portfolioId = portfolioId;
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        public CreateConstraintRequest build() {
            return new CreateConstraintRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateConstraintRequest> {
        public Builder acceptLanguage(String var1);

        public Builder portfolioId(String var1);

        public Builder productId(String var1);

        public Builder parameters(String var1);

        public Builder type(String var1);

        public Builder description(String var1);

        public Builder idempotencyToken(String var1);
    }
}

