/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.model.SearchProvisionedProductsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SearchProvisionedProductsRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACCESSLEVELFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccessLevelFilter").isBinary(false).build();
    private static final MarshallingInfo<Map> FILTERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filters").isBinary(false).build();
    private static final MarshallingInfo<String> SORTBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortBy").isBinary(false).build();
    private static final MarshallingInfo<String> SORTORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SortOrder").isBinary(false).build();
    private static final MarshallingInfo<Integer> PAGESIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageSize").isBinary(false).build();
    private static final MarshallingInfo<String> PAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PageToken").isBinary(false).build();
    private static final SearchProvisionedProductsRequestModelMarshaller INSTANCE = new SearchProvisionedProductsRequestModelMarshaller();

    private SearchProvisionedProductsRequestModelMarshaller() {
    }

    public static SearchProvisionedProductsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchProvisionedProductsRequest searchProvisionedProductsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)searchProvisionedProductsRequest), (String)"searchProvisionedProductsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)searchProvisionedProductsRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)searchProvisionedProductsRequest.accessLevelFilter(), ACCESSLEVELFILTER_BINDING);
            protocolMarshaller.marshall(searchProvisionedProductsRequest.filtersAsStrings(), FILTERS_BINDING);
            protocolMarshaller.marshall((Object)searchProvisionedProductsRequest.sortBy(), SORTBY_BINDING);
            protocolMarshaller.marshall((Object)searchProvisionedProductsRequest.sortOrderAsString(), SORTORDER_BINDING);
            protocolMarshaller.marshall((Object)searchProvisionedProductsRequest.pageSize(), PAGESIZE_BINDING);
            protocolMarshaller.marshall((Object)searchProvisionedProductsRequest.pageToken(), PAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

