/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ResourceTargetDefinition;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceTargetDefinitionMarshaller {
    private static final MarshallingInfo<String> ATTRIBUTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attribute").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> REQUIRESRECREATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RequiresRecreation").isBinary(false).build();
    private static final ResourceTargetDefinitionMarshaller INSTANCE = new ResourceTargetDefinitionMarshaller();

    private ResourceTargetDefinitionMarshaller() {
    }

    public static ResourceTargetDefinitionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceTargetDefinition resourceTargetDefinition, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceTargetDefinition, (String)"resourceTargetDefinition");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceTargetDefinition.attributeAsString(), ATTRIBUTE_BINDING);
            protocolMarshaller.marshall((Object)resourceTargetDefinition.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)resourceTargetDefinition.requiresRecreationAsString(), REQUIRESRECREATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

