/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ResourceChange;
import software.amazon.awssdk.services.servicecatalog.transform.ResourceChangeDetailUnmarshaller;

public class ResourceChangeUnmarshaller
implements Unmarshaller<ResourceChange, JsonUnmarshallerContext> {
    private static final ResourceChangeUnmarshaller INSTANCE = new ResourceChangeUnmarshaller();

    public ResourceChange unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResourceChange.Builder resourceChangeBuilder = ResourceChange.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Action", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.action((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LogicalResourceId", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.logicalResourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("PhysicalResourceId", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.physicalResourceId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourceType", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Replacement", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.replacement((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Scope", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.scopeWithStrings(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Details", targetDepth)) {
                    context.nextToken();
                    resourceChangeBuilder.details(new ListUnmarshaller((Unmarshaller)ResourceChangeDetailUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResourceChange)resourceChangeBuilder.build();
    }

    public static ResourceChangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

