/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicecatalog.model.RecordTag;

public class RecordTagUnmarshaller
implements Unmarshaller<RecordTag, JsonUnmarshallerContext> {
    private static final RecordTagUnmarshaller INSTANCE = new RecordTagUnmarshaller();

    public RecordTag unmarshall(JsonUnmarshallerContext context) throws Exception {
        RecordTag.Builder recordTagBuilder = RecordTag.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Key", targetDepth)) {
                    context.nextToken();
                    recordTagBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Value", targetDepth)) {
                    context.nextToken();
                    recordTagBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RecordTag)recordTagBuilder.build();
    }

    public static RecordTagUnmarshaller getInstance() {
        return INSTANCE;
    }
}

