/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicecatalog.model.RecordOutput;

public class RecordOutputUnmarshaller
implements Unmarshaller<RecordOutput, JsonUnmarshallerContext> {
    private static final RecordOutputUnmarshaller INSTANCE = new RecordOutputUnmarshaller();

    public RecordOutput unmarshall(JsonUnmarshallerContext context) throws Exception {
        RecordOutput.Builder recordOutputBuilder = RecordOutput.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OutputKey", targetDepth)) {
                    context.nextToken();
                    recordOutputBuilder.outputKey((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputValue", targetDepth)) {
                    context.nextToken();
                    recordOutputBuilder.outputValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    recordOutputBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (RecordOutput)recordOutputBuilder.build();
    }

    public static RecordOutputUnmarshaller getInstance() {
        return INSTANCE;
    }
}

