/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionedProductAttributeMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Arn").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedTime").isBinary(false).build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").isBinary(false).build();
    private static final MarshallingInfo<String> LASTRECORDID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastRecordId").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<String> PHYSICALID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PhysicalId").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONINGARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactId").isBinary(false).build();
    private static final MarshallingInfo<String> USERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserArn").isBinary(false).build();
    private static final MarshallingInfo<String> USERARNSESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserArnSession").isBinary(false).build();
    private static final ProvisionedProductAttributeMarshaller INSTANCE = new ProvisionedProductAttributeMarshaller();

    private ProvisionedProductAttributeMarshaller() {
    }

    public static ProvisionedProductAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionedProductAttribute provisionedProductAttribute, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)provisionedProductAttribute, (String)"provisionedProductAttribute");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionedProductAttribute.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.arn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.statusAsString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.statusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.createdTime(), CREATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.lastRecordId(), LASTRECORDID_BINDING);
            protocolMarshaller.marshall(provisionedProductAttribute.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.physicalId(), PHYSICALID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.provisioningArtifactId(), PROVISIONINGARTIFACTID_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.userArn(), USERARN_BINDING);
            protocolMarshaller.marshall((Object)provisionedProductAttribute.userArnSession(), USERARNSESSION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

