/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.Principal;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PrincipalMarshaller {
    private static final MarshallingInfo<String> PRINCIPALARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrincipalARN").isBinary(false).build();
    private static final MarshallingInfo<String> PRINCIPALTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrincipalType").isBinary(false).build();
    private static final PrincipalMarshaller INSTANCE = new PrincipalMarshaller();

    private PrincipalMarshaller() {
    }

    public static PrincipalMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Principal principal, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)principal, (String)"principal");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)principal.principalARN(), PRINCIPALARN_BINDING);
            protocolMarshaller.marshall((Object)principal.principalTypeAsString(), PRINCIPALTYPE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

