/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LaunchPathSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<List> CONSTRAINTSUMMARIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConstraintSummaries").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final LaunchPathSummaryMarshaller INSTANCE = new LaunchPathSummaryMarshaller();

    private LaunchPathSummaryMarshaller() {
    }

    public static LaunchPathSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LaunchPathSummary launchPathSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)launchPathSummary, (String)"launchPathSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)launchPathSummary.id(), ID_BINDING);
            protocolMarshaller.marshall(launchPathSummary.constraintSummaries(), CONSTRAINTSUMMARIES_BINDING);
            protocolMarshaller.marshall(launchPathSummary.tags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)launchPathSummary.name(), NAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

