/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.servicecatalog.model.CreateProvisionedProductPlanRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateProvisionedProductPlanRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<String> PLANNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanName").isBinary(false).build();
    private static final MarshallingInfo<String> PLANTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PlanType").isBinary(false).build();
    private static final MarshallingInfo<List> NOTIFICATIONARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationArns").isBinary(false).build();
    private static final MarshallingInfo<String> PATHID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PathId").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONEDPRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedProductName").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONINGARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactId").isBinary(false).build();
    private static final MarshallingInfo<List> PROVISIONINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningParameters").isBinary(false).build();
    private static final MarshallingInfo<String> IDEMPOTENCYTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IdempotencyToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final CreateProvisionedProductPlanRequestModelMarshaller INSTANCE = new CreateProvisionedProductPlanRequestModelMarshaller();

    private CreateProvisionedProductPlanRequestModelMarshaller() {
    }

    public static CreateProvisionedProductPlanRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateProvisionedProductPlanRequest createProvisionedProductPlanRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createProvisionedProductPlanRequest), (String)"createProvisionedProductPlanRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.planName(), PLANNAME_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.planTypeAsString(), PLANTYPE_BINDING);
            protocolMarshaller.marshall(createProvisionedProductPlanRequest.notificationArns(), NOTIFICATIONARNS_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.pathId(), PATHID_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.provisionedProductName(), PROVISIONEDPRODUCTNAME_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.provisioningArtifactId(), PROVISIONINGARTIFACTID_BINDING);
            protocolMarshaller.marshall(createProvisionedProductPlanRequest.provisioningParameters(), PROVISIONINGPARAMETERS_BINDING);
            protocolMarshaller.marshall((Object)createProvisionedProductPlanRequest.idempotencyToken(), IDEMPOTENCYTOKEN_BINDING);
            protocolMarshaller.marshall(createProvisionedProductPlanRequest.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

