/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttribute;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductAttributesCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchProvisionedProductsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, SearchProvisionedProductsResponse> {
    private final List<ProvisionedProductAttribute> provisionedProducts;
    private final Integer totalResultsCount;
    private final String nextPageToken;

    private SearchProvisionedProductsResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProducts = builder.provisionedProducts;
        this.totalResultsCount = builder.totalResultsCount;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProvisionedProductAttribute> provisionedProducts() {
        return this.provisionedProducts;
    }

    public Integer totalResultsCount() {
        return this.totalResultsCount;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProducts());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResultsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchProvisionedProductsResponse)) {
            return false;
        }
        SearchProvisionedProductsResponse other = (SearchProvisionedProductsResponse)((Object)obj);
        return Objects.equals(this.provisionedProducts(), other.provisionedProducts()) && Objects.equals(this.totalResultsCount(), other.totalResultsCount()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"SearchProvisionedProductsResponse").add("ProvisionedProducts", this.provisionedProducts()).add("TotalResultsCount", (Object)this.totalResultsCount()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProducts": {
                return Optional.ofNullable(clazz.cast(this.provisionedProducts()));
            }
            case "TotalResultsCount": {
                return Optional.ofNullable(clazz.cast(this.totalResultsCount()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedProductAttribute> provisionedProducts = DefaultSdkAutoConstructList.getInstance();
        private Integer totalResultsCount;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchProvisionedProductsResponse model) {
            super(model);
            this.provisionedProducts(model.provisionedProducts);
            this.totalResultsCount(model.totalResultsCount);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisionedProductAttribute.Builder> getProvisionedProducts() {
            return this.provisionedProducts != null ? (Collection)this.provisionedProducts.stream().map(ProvisionedProductAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedProducts(Collection<ProvisionedProductAttribute> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductAttributesCopier.copy(provisionedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(ProvisionedProductAttribute ... provisionedProducts) {
            this.provisionedProducts(Arrays.asList(provisionedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(Consumer<ProvisionedProductAttribute.Builder> ... provisionedProducts) {
            this.provisionedProducts(Stream.of(provisionedProducts).map(c -> (ProvisionedProductAttribute)((ProvisionedProductAttribute.Builder)ProvisionedProductAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedProducts(Collection<ProvisionedProductAttribute.BuilderImpl> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductAttributesCopier.copyFromBuilder(provisionedProducts);
        }

        public final Integer getTotalResultsCount() {
            return this.totalResultsCount;
        }

        @Override
        public final Builder totalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
            return this;
        }

        public final void setTotalResultsCount(Integer totalResultsCount) {
            this.totalResultsCount = totalResultsCount;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public SearchProvisionedProductsResponse build() {
            return new SearchProvisionedProductsResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, SearchProvisionedProductsResponse> {
        public Builder provisionedProducts(Collection<ProvisionedProductAttribute> var1);

        public Builder provisionedProducts(ProvisionedProductAttribute ... var1);

        public Builder provisionedProducts(Consumer<ProvisionedProductAttribute.Builder> ... var1);

        public Builder totalResultsCount(Integer var1);

        public Builder nextPageToken(String var1);
    }
}

