/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlanSummary;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductPlansCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProvisionedProductPlansResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListProvisionedProductPlansResponse> {
    private final List<ProvisionedProductPlanSummary> provisionedProductPlans;
    private final String nextPageToken;

    private ListProvisionedProductPlansResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductPlans = builder.provisionedProductPlans;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProvisionedProductPlanSummary> provisionedProductPlans() {
        return this.provisionedProductPlans;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductPlans());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProvisionedProductPlansResponse)) {
            return false;
        }
        ListProvisionedProductPlansResponse other = (ListProvisionedProductPlansResponse)((Object)obj);
        return Objects.equals(this.provisionedProductPlans(), other.provisionedProductPlans()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ListProvisionedProductPlansResponse").add("ProvisionedProductPlans", this.provisionedProductPlans()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductPlans": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductPlans()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedProductPlanSummary> provisionedProductPlans = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProvisionedProductPlansResponse model) {
            super(model);
            this.provisionedProductPlans(model.provisionedProductPlans);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisionedProductPlanSummary.Builder> getProvisionedProductPlans() {
            return this.provisionedProductPlans != null ? (Collection)this.provisionedProductPlans.stream().map(ProvisionedProductPlanSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedProductPlans(Collection<ProvisionedProductPlanSummary> provisionedProductPlans) {
            this.provisionedProductPlans = ProvisionedProductPlansCopier.copy(provisionedProductPlans);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProductPlans(ProvisionedProductPlanSummary ... provisionedProductPlans) {
            this.provisionedProductPlans(Arrays.asList(provisionedProductPlans));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProductPlans(Consumer<ProvisionedProductPlanSummary.Builder> ... provisionedProductPlans) {
            this.provisionedProductPlans(Stream.of(provisionedProductPlans).map(c -> (ProvisionedProductPlanSummary)((ProvisionedProductPlanSummary.Builder)ProvisionedProductPlanSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedProductPlans(Collection<ProvisionedProductPlanSummary.BuilderImpl> provisionedProductPlans) {
            this.provisionedProductPlans = ProvisionedProductPlansCopier.copyFromBuilder(provisionedProductPlans);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ListProvisionedProductPlansResponse build() {
            return new ListProvisionedProductPlansResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, ListProvisionedProductPlansResponse> {
        public Builder provisionedProductPlans(Collection<ProvisionedProductPlanSummary> var1);

        public Builder provisionedProductPlans(ProvisionedProductPlanSummary ... var1);

        public Builder provisionedProductPlans(Consumer<ProvisionedProductPlanSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

