/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboard;
import software.amazon.awssdk.services.servicecatalog.model.CloudWatchDashboardsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeProvisionedProductResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, DescribeProvisionedProductResponse> {
    private final ProvisionedProductDetail provisionedProductDetail;
    private final List<CloudWatchDashboard> cloudWatchDashboards;

    private DescribeProvisionedProductResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProductDetail = builder.provisionedProductDetail;
        this.cloudWatchDashboards = builder.cloudWatchDashboards;
    }

    public ProvisionedProductDetail provisionedProductDetail() {
        return this.provisionedProductDetail;
    }

    public List<CloudWatchDashboard> cloudWatchDashboards() {
        return this.cloudWatchDashboards;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProductDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchDashboards());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProvisionedProductResponse)) {
            return false;
        }
        DescribeProvisionedProductResponse other = (DescribeProvisionedProductResponse)((Object)obj);
        return Objects.equals(this.provisionedProductDetail(), other.provisionedProductDetail()) && Objects.equals(this.cloudWatchDashboards(), other.cloudWatchDashboards());
    }

    public String toString() {
        return ToString.builder((String)"DescribeProvisionedProductResponse").add("ProvisionedProductDetail", (Object)this.provisionedProductDetail()).add("CloudWatchDashboards", this.cloudWatchDashboards()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProductDetail": {
                return Optional.ofNullable(clazz.cast(this.provisionedProductDetail()));
            }
            case "CloudWatchDashboards": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchDashboards()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private ProvisionedProductDetail provisionedProductDetail;
        private List<CloudWatchDashboard> cloudWatchDashboards = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProvisionedProductResponse model) {
            super(model);
            this.provisionedProductDetail(model.provisionedProductDetail);
            this.cloudWatchDashboards(model.cloudWatchDashboards);
        }

        public final ProvisionedProductDetail.Builder getProvisionedProductDetail() {
            return this.provisionedProductDetail != null ? this.provisionedProductDetail.toBuilder() : null;
        }

        @Override
        public final Builder provisionedProductDetail(ProvisionedProductDetail provisionedProductDetail) {
            this.provisionedProductDetail = provisionedProductDetail;
            return this;
        }

        public final void setProvisionedProductDetail(ProvisionedProductDetail.BuilderImpl provisionedProductDetail) {
            this.provisionedProductDetail = provisionedProductDetail != null ? provisionedProductDetail.build() : null;
        }

        public final Collection<CloudWatchDashboard.Builder> getCloudWatchDashboards() {
            return this.cloudWatchDashboards != null ? (Collection)this.cloudWatchDashboards.stream().map(CloudWatchDashboard::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cloudWatchDashboards(Collection<CloudWatchDashboard> cloudWatchDashboards) {
            this.cloudWatchDashboards = CloudWatchDashboardsCopier.copy(cloudWatchDashboards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(CloudWatchDashboard ... cloudWatchDashboards) {
            this.cloudWatchDashboards(Arrays.asList(cloudWatchDashboards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloudWatchDashboards(Consumer<CloudWatchDashboard.Builder> ... cloudWatchDashboards) {
            this.cloudWatchDashboards(Stream.of(cloudWatchDashboards).map(c -> (CloudWatchDashboard)((CloudWatchDashboard.Builder)CloudWatchDashboard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCloudWatchDashboards(Collection<CloudWatchDashboard.BuilderImpl> cloudWatchDashboards) {
            this.cloudWatchDashboards = CloudWatchDashboardsCopier.copyFromBuilder(cloudWatchDashboards);
        }

        @Override
        public DescribeProvisionedProductResponse build() {
            return new DescribeProvisionedProductResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, DescribeProvisionedProductResponse> {
        public Builder provisionedProductDetail(ProvisionedProductDetail var1);

        default public Builder provisionedProductDetail(Consumer<ProvisionedProductDetail.Builder> provisionedProductDetail) {
            return this.provisionedProductDetail((ProvisionedProductDetail)((ProvisionedProductDetail.Builder)ProvisionedProductDetail.builder().applyMutation(provisionedProductDetail)).build());
        }

        public Builder cloudWatchDashboards(Collection<CloudWatchDashboard> var1);

        public Builder cloudWatchDashboards(CloudWatchDashboard ... var1);

        public Builder cloudWatchDashboards(Consumer<CloudWatchDashboard.Builder> ... var1);
    }
}

