/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionProductRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProvisionProductRequestModelMarshaller {
    private static final MarshallingInfo<String> ACCEPTLANGUAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AcceptLanguage").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONINGARTIFACTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningArtifactId").isBinary(false).build();
    private static final MarshallingInfo<String> PATHID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PathId").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONEDPRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionedProductName").isBinary(false).build();
    private static final MarshallingInfo<List> PROVISIONINGPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisioningParameters").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final MarshallingInfo<List> NOTIFICATIONARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NotificationArns").isBinary(false).build();
    private static final MarshallingInfo<String> PROVISIONTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProvisionToken").isBinary(false).defaultValueSupplier(IdempotentUtils.getGenerator()).build();
    private static final ProvisionProductRequestModelMarshaller INSTANCE = new ProvisionProductRequestModelMarshaller();

    private ProvisionProductRequestModelMarshaller() {
    }

    public static ProvisionProductRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProvisionProductRequest provisionProductRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)provisionProductRequest), (String)"provisionProductRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)provisionProductRequest.acceptLanguage(), ACCEPTLANGUAGE_BINDING);
            protocolMarshaller.marshall((Object)provisionProductRequest.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)provisionProductRequest.provisioningArtifactId(), PROVISIONINGARTIFACTID_BINDING);
            protocolMarshaller.marshall((Object)provisionProductRequest.pathId(), PATHID_BINDING);
            protocolMarshaller.marshall((Object)provisionProductRequest.provisionedProductName(), PROVISIONEDPRODUCTNAME_BINDING);
            protocolMarshaller.marshall(provisionProductRequest.provisioningParameters(), PROVISIONINGPARAMETERS_BINDING);
            protocolMarshaller.marshall(provisionProductRequest.tags(), TAGS_BINDING);
            protocolMarshaller.marshall(provisionProductRequest.notificationArns(), NOTIFICATIONARNS_BINDING);
            protocolMarshaller.marshall((Object)provisionProductRequest.provisionToken(), PROVISIONTOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

