/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.servicecatalog.model.ProductViewSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ProductViewSummaryMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> PRODUCTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductId").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").isBinary(false).build();
    private static final MarshallingInfo<String> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Owner").isBinary(false).build();
    private static final MarshallingInfo<String> SHORTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShortDescription").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").isBinary(false).build();
    private static final MarshallingInfo<String> DISTRIBUTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Distributor").isBinary(false).build();
    private static final MarshallingInfo<Boolean> HASDEFAULTPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HasDefaultPath").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTEMAIL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportEmail").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportDescription").isBinary(false).build();
    private static final MarshallingInfo<String> SUPPORTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportUrl").isBinary(false).build();
    private static final ProductViewSummaryMarshaller INSTANCE = new ProductViewSummaryMarshaller();

    private ProductViewSummaryMarshaller() {
    }

    public static ProductViewSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ProductViewSummary productViewSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)productViewSummary, (String)"productViewSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)productViewSummary.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.productId(), PRODUCTID_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.owner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.shortDescription(), SHORTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.distributor(), DISTRIBUTOR_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.hasDefaultPath(), HASDEFAULTPATH_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.supportEmail(), SUPPORTEMAIL_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.supportDescription(), SUPPORTDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)productViewSummary.supportUrl(), SUPPORTURL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

