/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.servicecatalog.model.ListRecordHistoryRequest;
import software.amazon.awssdk.services.servicecatalog.transform.ListRecordHistoryRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListRecordHistoryRequestMarshaller
implements Marshaller<Request<ListRecordHistoryRequest>, ListRecordHistoryRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AWS242ServiceCatalogService.ListRecordHistory").serviceName("AWS Service Catalog").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public ListRecordHistoryRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListRecordHistoryRequest> marshall(ListRecordHistoryRequest listRecordHistoryRequest) {
        Validate.paramNotNull((Object)((Object)listRecordHistoryRequest), (String)"listRecordHistoryRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)listRecordHistoryRequest);
            protocolMarshaller.startMarshalling();
            ListRecordHistoryRequestModelMarshaller.getInstance().marshall(listRecordHistoryRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

