/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsRequest;
import software.amazon.awssdk.services.servicecatalog.model.SearchProductsResponse;

public class SearchProductsPublisher
implements SdkPublisher<SearchProductsResponse> {
    private final ServiceCatalogAsyncClient client;
    private final SearchProductsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchProductsPublisher(ServiceCatalogAsyncClient client, SearchProductsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchProductsPublisher(ServiceCatalogAsyncClient client, SearchProductsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchProductsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchProductsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final SearchProductsPublisher resume(SearchProductsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new SearchProductsPublisher(this.client, (SearchProductsRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new SearchProductsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super SearchProductsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class SearchProductsResponseFetcher
    implements AsyncPageFetcher<SearchProductsResponse> {
        private SearchProductsResponseFetcher() {
        }

        public boolean hasNextPage(SearchProductsResponse previousPage) {
            return previousPage.nextPageToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextPageToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextPageToken());
        }

        public CompletableFuture<SearchProductsResponse> nextPage(SearchProductsResponse previousPage) {
            if (previousPage == null) {
                return SearchProductsPublisher.this.client.searchProducts(SearchProductsPublisher.this.firstRequest);
            }
            return SearchProductsPublisher.this.client.searchProducts((SearchProductsRequest)((Object)SearchProductsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

