/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesRequest;
import software.amazon.awssdk.services.servicecatalog.model.ListAcceptedPortfolioSharesResponse;

public class ListAcceptedPortfolioSharesPublisher
implements SdkPublisher<ListAcceptedPortfolioSharesResponse> {
    private final ServiceCatalogAsyncClient client;
    private final ListAcceptedPortfolioSharesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAcceptedPortfolioSharesPublisher(ServiceCatalogAsyncClient client, ListAcceptedPortfolioSharesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAcceptedPortfolioSharesPublisher(ServiceCatalogAsyncClient client, ListAcceptedPortfolioSharesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAcceptedPortfolioSharesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAcceptedPortfolioSharesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListAcceptedPortfolioSharesPublisher resume(ListAcceptedPortfolioSharesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAcceptedPortfolioSharesPublisher(this.client, (ListAcceptedPortfolioSharesRequest)((Object)this.firstRequest.toBuilder().pageToken(lastSuccessfulPage.nextPageToken()).build()));
        }
        return new ListAcceptedPortfolioSharesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListAcceptedPortfolioSharesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListAcceptedPortfolioSharesResponseFetcher
    implements AsyncPageFetcher<ListAcceptedPortfolioSharesResponse> {
        private ListAcceptedPortfolioSharesResponseFetcher() {
        }

        public boolean hasNextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            return previousPage.nextPageToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextPageToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextPageToken());
        }

        public CompletableFuture<ListAcceptedPortfolioSharesResponse> nextPage(ListAcceptedPortfolioSharesResponse previousPage) {
            if (previousPage == null) {
                return ListAcceptedPortfolioSharesPublisher.this.client.listAcceptedPortfolioShares(ListAcceptedPortfolioSharesPublisher.this.firstRequest);
            }
            return ListAcceptedPortfolioSharesPublisher.this.client.listAcceptedPortfolioShares((ListAcceptedPortfolioSharesRequest)((Object)ListAcceptedPortfolioSharesPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

