/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicecatalog.transform.UpdateProvisioningParameterMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProvisioningParameter
implements StructuredPojo,
ToCopyableBuilder<Builder, UpdateProvisioningParameter> {
    private final String key;
    private final String value;
    private final Boolean usePreviousValue;

    private UpdateProvisioningParameter(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.usePreviousValue = builder.usePreviousValue;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Boolean usePreviousValue() {
        return this.usePreviousValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.usePreviousValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProvisioningParameter)) {
            return false;
        }
        UpdateProvisioningParameter other = (UpdateProvisioningParameter)obj;
        return Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.usePreviousValue(), other.usePreviousValue());
    }

    public String toString() {
        return ToString.builder((String)"UpdateProvisioningParameter").add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("UsePreviousValue", (Object)this.usePreviousValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "UsePreviousValue": {
                return Optional.ofNullable(clazz.cast(this.usePreviousValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UpdateProvisioningParameterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private String value;
        private Boolean usePreviousValue;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProvisioningParameter model) {
            this.key(model.key);
            this.value(model.value);
            this.usePreviousValue(model.usePreviousValue);
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getUsePreviousValue() {
            return this.usePreviousValue;
        }

        @Override
        public final Builder usePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
            return this;
        }

        public final void setUsePreviousValue(Boolean usePreviousValue) {
            this.usePreviousValue = usePreviousValue;
        }

        public UpdateProvisioningParameter build() {
            return new UpdateProvisioningParameter(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateProvisioningParameter> {
        public Builder key(String var1);

        public Builder value(String var1);

        public Builder usePreviousValue(Boolean var1);
    }
}

