/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetail;
import software.amazon.awssdk.services.servicecatalog.model.ProvisionedProductDetailsCopier;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanProvisionedProductsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ScanProvisionedProductsResponse> {
    private final List<ProvisionedProductDetail> provisionedProducts;
    private final String nextPageToken;

    private ScanProvisionedProductsResponse(BuilderImpl builder) {
        super(builder);
        this.provisionedProducts = builder.provisionedProducts;
        this.nextPageToken = builder.nextPageToken;
    }

    public List<ProvisionedProductDetail> provisionedProducts() {
        return this.provisionedProducts;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedProducts());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanProvisionedProductsResponse)) {
            return false;
        }
        ScanProvisionedProductsResponse other = (ScanProvisionedProductsResponse)((Object)obj);
        return Objects.equals(this.provisionedProducts(), other.provisionedProducts()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"ScanProvisionedProductsResponse").add("ProvisionedProducts", this.provisionedProducts()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisionedProducts": {
                return Optional.ofNullable(clazz.cast(this.provisionedProducts()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<ProvisionedProductDetail> provisionedProducts = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanProvisionedProductsResponse model) {
            super(model);
            this.provisionedProducts(model.provisionedProducts);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<ProvisionedProductDetail.Builder> getProvisionedProducts() {
            return this.provisionedProducts != null ? (Collection)this.provisionedProducts.stream().map(ProvisionedProductDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder provisionedProducts(Collection<ProvisionedProductDetail> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductDetailsCopier.copy(provisionedProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(ProvisionedProductDetail ... provisionedProducts) {
            this.provisionedProducts(Arrays.asList(provisionedProducts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisionedProducts(Consumer<ProvisionedProductDetail.Builder> ... provisionedProducts) {
            this.provisionedProducts(Stream.of(provisionedProducts).map(c -> (ProvisionedProductDetail)((ProvisionedProductDetail.Builder)ProvisionedProductDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisionedProducts(Collection<ProvisionedProductDetail.BuilderImpl> provisionedProducts) {
            this.provisionedProducts = ProvisionedProductDetailsCopier.copyFromBuilder(provisionedProducts);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public ScanProvisionedProductsResponse build() {
            return new ScanProvisionedProductsResponse(this);
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    CopyableBuilder<Builder, ScanProvisionedProductsResponse> {
        public Builder provisionedProducts(Collection<ProvisionedProductDetail> var1);

        public Builder provisionedProducts(ProvisionedProductDetail ... var1);

        public Builder provisionedProducts(Consumer<ProvisionedProductDetail.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

