/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service;

import java.util.Random;
import software.amazon.awssdk.utils.JavaSystemSetting;
import software.amazon.awssdk.utils.StringUtils;

public final class S3BucketUtils {
    private static final Random RANDOM = new Random();
    private static final int MAX_BUCKET_NAME_LENGTH = 63;

    private S3BucketUtils() {
    }

    public static String temporaryBucketName() {
        String callingClass = Thread.currentThread().getStackTrace()[2].getClassName();
        return S3BucketUtils.temporaryBucketName(S3BucketUtils.shortenClassName(callingClass.substring(callingClass.lastIndexOf(46))));
    }

    public static String temporaryBucketName(Object clz) {
        return S3BucketUtils.temporaryBucketName(clz.getClass());
    }

    public static String temporaryBucketName(Class<?> clz) {
        return S3BucketUtils.temporaryBucketName(S3BucketUtils.shortenClassName(clz.getSimpleName()));
    }

    public static String temporaryBucketName(String prefix) {
        String bucketName = StringUtils.lowerCase((String)prefix) + "-" + StringUtils.lowerCase((String)JavaSystemSetting.USER_NAME.getStringValueOrThrow()) + "-" + RANDOM.nextInt(10000);
        if (bucketName.length() > 63) {
            throw new RuntimeException("S3 buckets can only be 63 chars in length, try a shorter prefix");
        }
        return bucketName;
    }

    private static String shortenClassName(String clzName) {
        return clzName.length() <= 45 ? clzName : clzName.substring(0, 45);
    }
}

