/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.testutils.service.http.MockHttpClient;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Pair;

public final class MockAsyncHttpClient
implements SdkAsyncHttpClient,
MockHttpClient {
    private static final Duration DEFAULT_DURATION = Duration.ofMillis(50L);
    private final List<SdkHttpRequest> capturedRequests = new ArrayList<SdkHttpRequest>();
    private final List<Pair<HttpExecuteResponse, Duration>> responses = new LinkedList<Pair<HttpExecuteResponse, Duration>>();
    private final AtomicInteger responseIndex = new AtomicInteger(0);
    private final ExecutorService executor = Executors.newFixedThreadPool(3);
    private Integer asyncRequestBodyLength;
    private byte[] streamingPayload;

    public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
        this.capturedRequests.add(request.request());
        int index = this.responseIndex.getAndIncrement() % this.responses.size();
        HttpExecuteResponse nextResponse = (HttpExecuteResponse)this.responses.get(index).left();
        byte[] content = nextResponse.responseBody().map(p -> (byte[])FunctionalUtils.invokeSafely(() -> IoUtils.toByteArray((InputStream)p))).orElseGet(() -> new byte[0]);
        request.responseHandler().onHeaders(nextResponse.httpResponse());
        CompletableFuture.runAsync(() -> request.responseHandler().onStream((Publisher)new ResponsePublisher(content, index)), this.executor);
        if (this.asyncRequestBodyLength != null && this.asyncRequestBodyLength > 0) {
            this.captureStreamingPayload(request.requestContentPublisher());
        }
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
        this.executor.shutdown();
    }

    @Override
    public void reset() {
        this.capturedRequests.clear();
        this.responses.clear();
        this.responseIndex.set(0);
    }

    @Override
    public List<SdkHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.capturedRequests);
    }

    @Override
    public SdkHttpRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }

    @Override
    public void stubNextResponse(HttpExecuteResponse nextResponse) {
        this.responses.clear();
        this.responses.add((Pair<HttpExecuteResponse, Duration>)Pair.of((Object)nextResponse, (Object)DEFAULT_DURATION));
        this.responseIndex.set(0);
    }

    @Override
    public void stubNextResponse(HttpExecuteResponse nextResponse, Duration delay) {
        this.responses.clear();
        this.responses.add((Pair<HttpExecuteResponse, Duration>)Pair.of((Object)nextResponse, (Object)delay));
        this.responseIndex.set(0);
    }

    @Override
    public void stubResponses(Pair<HttpExecuteResponse, Duration> ... responses) {
        this.responses.clear();
        this.responses.addAll(Arrays.asList(responses));
        this.responseIndex.set(0);
    }

    @Override
    public void stubResponses(HttpExecuteResponse ... responses) {
        this.responses.clear();
        this.responses.addAll(Arrays.stream(responses).map(r -> Pair.of((Object)r, (Object)DEFAULT_DURATION)).collect(Collectors.toList()));
        this.responseIndex.set(0);
    }

    public void setAsyncRequestBodyLength(int asyncRequestBodyLength) {
        this.asyncRequestBodyLength = asyncRequestBodyLength;
    }

    private void captureStreamingPayload(SdkHttpContentPublisher publisher) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.asyncRequestBodyLength);
        CapturingSubscriber subscriber = new CapturingSubscriber(byteBuffer);
        publisher.subscribe((Subscriber)subscriber);
        this.streamingPayload = byteBuffer.array();
    }

    public Optional<byte[]> getStreamingPayload() {
        return this.streamingPayload != null ? Optional.of(this.streamingPayload.clone()) : Optional.empty();
    }

    private static class CapturingSubscriber
    implements Subscriber<ByteBuffer> {
        private ByteBuffer byteBuffer;
        private CountDownLatch done = new CountDownLatch(1);

        CapturingSubscriber(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(ByteBuffer buffer) {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            this.byteBuffer.put(bytes);
        }

        public void onError(Throwable t) {
            this.done.countDown();
        }

        public void onComplete() {
            this.done.countDown();
        }
    }

    private final class ResponsePublisher
    implements SdkHttpContentPublisher {
        private final byte[] content;
        private final int index;

        private ResponsePublisher(byte[] content, int index) {
            this.content = content;
            this.index = index;
        }

        public Optional<Long> contentLength() {
            return Optional.of(Long.valueOf(this.content.length));
        }

        public void subscribe(final Subscriber<? super ByteBuffer> s) {
            s.onSubscribe(new Subscription(){
                private boolean running = true;

                public void request(long n) {
                    if (n <= 0L) {
                        this.running = false;
                        s.onError((Throwable)new IllegalArgumentException("Demand must be positive"));
                    } else if (this.running) {
                        this.running = false;
                        s.onNext((Object)ByteBuffer.wrap(ResponsePublisher.this.content));
                        try {
                            Thread.sleep(((Duration)((Pair)MockAsyncHttpClient.this.responses.get(ResponsePublisher.this.index)).right()).toMillis());
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        s.onComplete();
                    }
                }

                public void cancel() {
                    this.running = false;
                }
            });
        }
    }
}

