/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service.http;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.testutils.service.http.MockHttpClient;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.IoUtils;

public final class MockAsyncHttpClient
implements SdkAsyncHttpClient,
MockHttpClient {
    private final List<SdkHttpRequest> capturedRequests = new ArrayList<SdkHttpRequest>();
    private final List<HttpExecuteResponse> responses = new LinkedList<HttpExecuteResponse>();
    private final AtomicInteger responseIndex = new AtomicInteger(0);

    public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
        this.capturedRequests.add(request.request());
        HttpExecuteResponse nextResponse = this.responses.get(this.responseIndex.getAndIncrement() % this.responses.size());
        byte[] content = nextResponse.responseBody().map(p -> (byte[])FunctionalUtils.invokeSafely(() -> IoUtils.toByteArray((InputStream)p))).orElseGet(() -> new byte[0]);
        request.responseHandler().onHeaders(nextResponse.httpResponse());
        request.responseHandler().onStream((Publisher)new ResponsePublisher(content));
        return CompletableFuture.completedFuture(null);
    }

    public void close() {
    }

    @Override
    public void reset() {
        this.capturedRequests.clear();
        this.responses.clear();
        this.responseIndex.set(0);
    }

    @Override
    public List<SdkHttpRequest> getRequests() {
        return Collections.unmodifiableList(this.capturedRequests);
    }

    @Override
    public SdkHttpRequest getLastRequest() {
        if (this.capturedRequests.isEmpty()) {
            throw new IllegalStateException("No requests were captured by the mock");
        }
        return this.capturedRequests.get(this.capturedRequests.size() - 1);
    }

    @Override
    public void stubNextResponse(HttpExecuteResponse nextResponse) {
        this.responses.clear();
        this.responses.add(nextResponse);
        this.responseIndex.set(0);
    }

    @Override
    public void stubResponses(HttpExecuteResponse ... responses) {
        this.responses.clear();
        this.responses.addAll(Arrays.asList(responses));
        this.responseIndex.set(0);
    }

    private static class ResponsePublisher
    implements SdkHttpContentPublisher {
        private final byte[] content;

        private ResponsePublisher(byte[] content) {
            this.content = content;
        }

        public Optional<Long> contentLength() {
            return Optional.of(Long.valueOf(this.content.length));
        }

        public void subscribe(final Subscriber<? super ByteBuffer> s) {
            s.onSubscribe(new Subscription(){
                private boolean running = true;

                public void request(long n) {
                    if (n <= 0L) {
                        this.running = false;
                        s.onError((Throwable)new IllegalArgumentException("Demand must be positive"));
                    } else if (this.running) {
                        this.running = false;
                        s.onNext((Object)ByteBuffer.wrap(content));
                        s.onComplete();
                    }
                }

                public void cancel() {
                    this.running = false;
                }
            });
        }
    }
}

