/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.testutils.service;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.core.auth.AwsCredentials;
import software.amazon.awssdk.core.auth.AwsCredentialsProvider;
import software.amazon.awssdk.core.auth.AwsCredentialsProviderChain;
import software.amazon.awssdk.core.auth.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.core.auth.ProfileCredentialsProvider;
import software.amazon.awssdk.core.auth.StaticCredentialsProvider;
import software.amazon.awssdk.core.auth.SystemPropertyCredentialsProvider;
import software.amazon.awssdk.utils.IoUtils;

public abstract class AwsIntegrationTestBase {
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-test-account";
    public static final AwsCredentialsProviderChain CREDENTIALS_PROVIDER_CHAIN = AwsCredentialsProviderChain.builder().credentialsProviders(new AwsCredentialsProvider[]{ProfileCredentialsProvider.builder().profileName("aws-test-account").build(), new SystemPropertyCredentialsProvider(), new EnvironmentVariableCredentialsProvider()}).build();
    private static final AwsCredentials CREDENTIALS = CREDENTIALS_PROVIDER_CHAIN.getCredentials();

    @Deprecated
    protected static AwsCredentials getCredentials() {
        return CREDENTIALS;
    }

    protected static AwsCredentialsProvider getCredentialsProvider() {
        return new StaticCredentialsProvider(CREDENTIALS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getResourceAsString(Class<?> clazz, String location) {
        try (InputStream resourceStream = clazz.getResourceAsStream(location);){
            String resourceAsString = IoUtils.toString((InputStream)resourceStream);
            resourceStream.close();
            String string = resourceAsString;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

