/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateApplicationVersionResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.CreateCloudFormationChangeSetResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationPolicyResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.GetApplicationResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationVersionsResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListApplicationsResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.PutApplicationPolicyResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing null asynchronously. This can be created using the static {@link #builder()} method.
 *
 * AWS Serverless Repository
 */
@Generated("software.amazon.awssdk:codegen")
public interface ServerlessApplicationRepositoryAsyncClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "serverlessrepo";

    /**
     * Create a {@link ServerlessApplicationRepositoryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static ServerlessApplicationRepositoryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServerlessApplicationRepositoryAsyncClient}.
     */
    static ServerlessApplicationRepositoryAsyncClientBuilder builder() {
        return new DefaultServerlessApplicationRepositoryAsyncClientBuilder();
    }

    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same
     * call.
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an application, optionally including an AWS SAM file to create the first application version in the same
     * call.<br/>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     *
     * @param createApplicationRequest
     *        a {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder}.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().apply(createApplicationRequest).build());
    }

    /**
     * Creates an application version.
     *
     * @param createApplicationVersionRequest
     * @return A Java Future containing the result of the CreateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(
            CreateApplicationVersionRequest createApplicationVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an application version.<br/>
     * This is a convenience which creates an instance of the {@link CreateApplicationVersionRequest.Builder} avoiding
     * the need to create one manually via {@link CreateApplicationVersionRequest#builder()}
     *
     * @param createApplicationVersionRequest
     *        a {@link Consumer} that will call methods on {@link CreateApplicationVersionRequest.Builder}.
     * @return A Java Future containing the result of the CreateApplicationVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateApplicationVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateApplicationVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateApplicationVersionResponse> createApplicationVersion(
            Consumer<CreateApplicationVersionRequest.Builder> createApplicationVersionRequest) {
        return createApplicationVersion(CreateApplicationVersionRequest.builder().apply(createApplicationVersionRequest).build());
    }

    /**
     * Creates an AWS CloudFormation ChangeSet for the given application.
     *
     * @param createCloudFormationChangeSetRequest
     *        Create application ChangeSet request
     * @return A Java Future containing the result of the CreateCloudFormationChangeSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateCloudFormationChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFormationChangeSetResponse> createCloudFormationChangeSet(
            CreateCloudFormationChangeSetRequest createCloudFormationChangeSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Creates an AWS CloudFormation ChangeSet for the given application.<br/>
     * This is a convenience which creates an instance of the {@link CreateCloudFormationChangeSetRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCloudFormationChangeSetRequest#builder()}
     *
     * @param createCloudFormationChangeSetRequest
     *        a {@link Consumer} that will call methods on {@link CreateCloudFormationChangeSetRequest.Builder}.
     * @return A Java Future containing the result of the CreateCloudFormationChangeSet operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.CreateCloudFormationChangeSet
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/CreateCloudFormationChangeSet"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCloudFormationChangeSetResponse> createCloudFormationChangeSet(
            Consumer<CreateCloudFormationChangeSetRequest.Builder> createCloudFormationChangeSetRequest) {
        return createCloudFormationChangeSet(CreateCloudFormationChangeSetRequest.builder()
                .apply(createCloudFormationChangeSetRequest).build());
    }

    /**
     * Gets the specified application.
     *
     * @param getApplicationRequest
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(GetApplicationRequest getApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the specified application.<br/>
     * This is a convenience which creates an instance of the {@link GetApplicationRequest.Builder} avoiding the need to
     * create one manually via {@link GetApplicationRequest#builder()}
     *
     * @param getApplicationRequest
     *        a {@link Consumer} that will call methods on {@link GetApplicationRequest.Builder}.
     * @return A Java Future containing the result of the GetApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetApplicationResponse> getApplication(Consumer<GetApplicationRequest.Builder> getApplicationRequest) {
        return getApplication(GetApplicationRequest.builder().apply(getApplicationRequest).build());
    }

    /**
     * Gets the policy for the specified application.
     *
     * @param getApplicationPolicyRequest
     * @return A Java Future containing the result of the GetApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplicationPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationPolicyResponse> getApplicationPolicy(
            GetApplicationPolicyRequest getApplicationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Gets the policy for the specified application.<br/>
     * This is a convenience which creates an instance of the {@link GetApplicationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetApplicationPolicyRequest#builder()}
     *
     * @param getApplicationPolicyRequest
     *        a {@link Consumer} that will call methods on {@link GetApplicationPolicyRequest.Builder}.
     * @return A Java Future containing the result of the GetApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.GetApplicationPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/GetApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetApplicationPolicyResponse> getApplicationPolicy(
            Consumer<GetApplicationPolicyRequest.Builder> getApplicationPolicyRequest) {
        return getApplicationPolicy(GetApplicationPolicyRequest.builder().apply(getApplicationPolicyRequest).build());
    }

    /**
     * Lists versions for the specified application.
     *
     * @param listApplicationVersionsRequest
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            ListApplicationVersionsRequest listApplicationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists versions for the specified application.<br/>
     * This is a convenience which creates an instance of the {@link ListApplicationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListApplicationVersionsRequest#builder()}
     *
     * @param listApplicationVersionsRequest
     *        a {@link Consumer} that will call methods on {@link ListApplicationVersionsRequest.Builder}.
     * @return A Java Future containing the result of the ListApplicationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplicationVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplicationVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationVersionsResponse> listApplicationVersions(
            Consumer<ListApplicationVersionsRequest.Builder> listApplicationVersionsRequest) {
        return listApplicationVersions(ListApplicationVersionsRequest.builder().apply(listApplicationVersionsRequest).build());
    }

    /**
     * Lists applications owned by the requester.
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Lists applications owned by the requester.
     *
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications() {
        return listApplications(ListApplicationsRequest.builder().build());
    }

    /**
     * Lists applications owned by the requester.<br/>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     *
     * @param listApplicationsRequest
     *        a {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder}.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.ListApplications
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/ListApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().apply(listApplicationsRequest).build());
    }

    /**
     * Puts the policy for the specified application.
     *
     * @param putApplicationPolicyRequest
     *        Put policy request
     * @return A Java Future containing the result of the PutApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.PutApplicationPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationPolicyResponse> putApplicationPolicy(
            PutApplicationPolicyRequest putApplicationPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Puts the policy for the specified application.<br/>
     * This is a convenience which creates an instance of the {@link PutApplicationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link PutApplicationPolicyRequest#builder()}
     *
     * @param putApplicationPolicyRequest
     *        a {@link Consumer} that will call methods on {@link PutApplicationPolicyRequest.Builder}.
     * @return A Java Future containing the result of the PutApplicationPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.PutApplicationPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutApplicationPolicyResponse> putApplicationPolicy(
            Consumer<PutApplicationPolicyRequest.Builder> putApplicationPolicyRequest) {
        return putApplicationPolicy(PutApplicationPolicyRequest.builder().apply(putApplicationPolicyRequest).build());
    }

    /**
     * Updates the specified application.
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Updates the specified application.<br/>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     *
     * @param updateApplicationRequest
     *        a {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder}.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException 400 response</li>
     *         <li>InternalServerErrorException 500 response</li>
     *         <li>ForbiddenException 403 response</li>
     *         <li>NotFoundException 404 response</li>
     *         <li>TooManyRequestsException 429 response</li>
     *         <li>ConflictException 409 response</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServerlessApplicationRepositoryException Base class for all service exceptions. Unknown exceptions
     *         will be thrown as an instance of this type.</li>
     *         </ul>
     * @sample ServerlessApplicationRepositoryAsyncClient.UpdateApplication
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/UpdateApplication"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().apply(updateApplicationRequest).build());
    }
}
