/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary;

@SdkInternalApi
public class ApplicationSummaryMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationId").build();
    private static final MarshallingInfo<String> AUTHOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("author").build();
    private static final MarshallingInfo<String> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> SPDXLICENSEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spdxLicenseId").build();
    private static final ApplicationSummaryMarshaller INSTANCE = new ApplicationSummaryMarshaller();

    public static ApplicationSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationSummary applicationSummary, ProtocolMarshaller protocolMarshaller) {
        if (applicationSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)applicationSummary.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.author(), AUTHOR_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(applicationSummary.labels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.spdxLicenseId(), SPDXLICENSEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

