/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationVersionRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<CreateApplicationVersionRequest.Builder, CreateApplicationVersionRequest> {
    private final String applicationId;

    private final String semanticVersion;

    private final String sourceCodeUrl;

    private final String templateBody;

    private final String templateUrl;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.templateBody = builder.templateBody;
        this.templateUrl = builder.templateUrl;
    }

    /**
     * The id of the application to create a new version for
     * 
     * @return The id of the application to create a new version for
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * The semantic version of the new version
     * 
     * @return The semantic version of the new version
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * A link to a public repository for the source code of your application.
     * 
     * @return A link to a public repository for the source code of your application.
     */
    public String sourceCodeUrl() {
        return sourceCodeUrl;
    }

    /**
     * The raw packaged SAM template of your application.
     * 
     * @return The raw packaged SAM template of your application.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * A link to the packaged SAM template of your application.
     * 
     * @return A link to the packaged SAM template of your application.
     */
    public String templateUrl() {
        return templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateUrl(), other.templateUrl());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateApplicationVersionRequest").add("ApplicationId", applicationId())
                .add("SemanticVersion", semanticVersion()).add("SourceCodeUrl", sourceCodeUrl())
                .add("TemplateBody", templateBody()).add("TemplateUrl", templateUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "SourceCodeUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeUrl()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateUrl":
            return Optional.ofNullable(clazz.cast(templateUrl()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder,
            CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        /**
         * The id of the application to create a new version for
         * 
         * @param applicationId
         *        The id of the application to create a new version for
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * The semantic version of the new version
         * 
         * @param semanticVersion
         *        The semantic version of the new version
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * A link to a public repository for the source code of your application.
         * 
         * @param sourceCodeUrl
         *        A link to a public repository for the source code of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeUrl(String sourceCodeUrl);

        /**
         * The raw packaged SAM template of your application.
         * 
         * @param templateBody
         *        The raw packaged SAM template of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * A link to the packaged SAM template of your application.
         * 
         * @param templateUrl
         *        A link to the packaged SAM template of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUrl(String templateUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String semanticVersion;

        private String sourceCodeUrl;

        private String templateBody;

        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            super(model);
            applicationId(model.applicationId);
            semanticVersion(model.semanticVersion);
            sourceCodeUrl(model.sourceCodeUrl);
            templateBody(model.templateBody);
            templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeUrl() {
            return sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateUrl() {
            return templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }
    }
}
