/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.UpdateApplicationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateApplicationRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("applicationId").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("author").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").isBinary(false).build();
    private static final MarshallingInfo<String> READMEBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readmeBody").isBinary(false).build();
    private static final MarshallingInfo<String> READMEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("readmeUrl").isBinary(false).build();
    private static final UpdateApplicationRequestModelMarshaller INSTANCE = new UpdateApplicationRequestModelMarshaller();

    private UpdateApplicationRequestModelMarshaller() {
    }

    public static UpdateApplicationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateApplicationRequest updateApplicationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateApplicationRequest), (String)"updateApplicationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateApplicationRequest.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)updateApplicationRequest.author(), AUTHOR_BINDING);
            protocolMarshaller.marshall((Object)updateApplicationRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(updateApplicationRequest.labels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)updateApplicationRequest.readmeBody(), READMEBODY_BINDING);
            protocolMarshaller.marshall((Object)updateApplicationRequest.readmeUrl(), READMEURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

