/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ApplicationSummary;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ApplicationSummaryMarshaller {
    private static final MarshallingInfo<String> APPLICATIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationId").isBinary(false).build();
    private static final MarshallingInfo<String> AUTHOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("author").isBinary(false).build();
    private static final MarshallingInfo<String> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationTime").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<List> LABELS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("labels").isBinary(false).build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> SPDXLICENSEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("spdxLicenseId").isBinary(false).build();
    private static final ApplicationSummaryMarshaller INSTANCE = new ApplicationSummaryMarshaller();

    private ApplicationSummaryMarshaller() {
    }

    public static ApplicationSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ApplicationSummary applicationSummary, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)applicationSummary, (String)"applicationSummary");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)applicationSummary.applicationId(), APPLICATIONID_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.author(), AUTHOR_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.creationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(applicationSummary.labels(), LABELS_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)applicationSummary.spdxLicenseId(), SPDXLICENSEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

