/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOfParameterDefinitionCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterDefinition;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.VersionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Version
implements StructuredPojo,
ToCopyableBuilder<Builder, Version> {
    private final String applicationId;
    private final String creationTime;
    private final List<ParameterDefinition> parameterDefinitions;
    private final String semanticVersion;
    private final String sourceCodeUrl;
    private final String templateUrl;

    private Version(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.creationTime = builder.creationTime;
        this.parameterDefinitions = builder.parameterDefinitions;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.templateUrl = builder.templateUrl;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public List<ParameterDefinition> parameterDefinitions() {
        return this.parameterDefinitions;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String sourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    public String templateUrl() {
        return this.templateUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterDefinitions());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.parameterDefinitions(), other.parameterDefinitions()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(this.templateUrl(), other.templateUrl());
    }

    public String toString() {
        return ToString.builder((String)"Version").add("ApplicationId", (Object)this.applicationId()).add("CreationTime", (Object)this.creationTime()).add("ParameterDefinitions", this.parameterDefinitions()).add("SemanticVersion", (Object)this.semanticVersion()).add("SourceCodeUrl", (Object)this.sourceCodeUrl()).add("TemplateUrl", (Object)this.templateUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "ParameterDefinitions": {
                return Optional.of(clazz.cast(this.parameterDefinitions()));
            }
            case "SemanticVersion": {
                return Optional.of(clazz.cast(this.semanticVersion()));
            }
            case "SourceCodeUrl": {
                return Optional.of(clazz.cast(this.sourceCodeUrl()));
            }
            case "TemplateUrl": {
                return Optional.of(clazz.cast(this.templateUrl()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String creationTime;
        private List<ParameterDefinition> parameterDefinitions;
        private String semanticVersion;
        private String sourceCodeUrl;
        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Version model) {
            this.applicationId(model.applicationId);
            this.creationTime(model.creationTime);
            this.parameterDefinitions(model.parameterDefinitions);
            this.semanticVersion(model.semanticVersion);
            this.sourceCodeUrl(model.sourceCodeUrl);
            this.templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final Collection<ParameterDefinition.Builder> getParameterDefinitions() {
            return this.parameterDefinitions != null ? (Collection)this.parameterDefinitions.stream().map(ParameterDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterDefinitions(Collection<ParameterDefinition> parameterDefinitions) {
            this.parameterDefinitions = ListOfParameterDefinitionCopier.copy(parameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(ParameterDefinition ... parameterDefinitions) {
            this.parameterDefinitions(Arrays.asList(parameterDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterDefinitions(Consumer<ParameterDefinition.Builder> ... parameterDefinitions) {
            this.parameterDefinitions(Stream.of(parameterDefinitions).map(c -> (ParameterDefinition)((ParameterDefinition.Builder)ParameterDefinition.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterDefinitions(Collection<ParameterDefinition.BuilderImpl> parameterDefinitions) {
            this.parameterDefinitions = ListOfParameterDefinitionCopier.copyFromBuilder(parameterDefinitions);
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeUrl() {
            return this.sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getTemplateUrl() {
            return this.templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        public Version build() {
            return new Version(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Version> {
        public Builder applicationId(String var1);

        public Builder creationTime(String var1);

        public Builder parameterDefinitions(Collection<ParameterDefinition> var1);

        public Builder parameterDefinitions(ParameterDefinition ... var1);

        public Builder parameterDefinitions(Consumer<ParameterDefinition.Builder> ... var1);

        public Builder semanticVersion(String var1);

        public Builder sourceCodeUrl(String var1);

        public Builder templateUrl(String var1);
    }
}

