/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationsRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, ListApplicationsRequest> {
    private final Integer maxItems;
    private final String nextToken;

    private ListApplicationsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.nextToken = builder.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsRequest)) {
            return false;
        }
        ListApplicationsRequest other = (ListApplicationsRequest)((Object)obj);
        return Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationsRequest").add("MaxItems", (Object)this.maxItems()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxItems": {
                return Optional.of(clazz.cast(this.maxItems()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsRequest model) {
            super(model);
            this.maxItems(model.maxItems);
            this.nextToken(model.nextToken);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationsRequest build() {
            return new ListApplicationsRequest(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    CopyableBuilder<Builder, ListApplicationsRequest> {
        public Builder maxItems(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

