/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOfParameterValueCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ParameterValue;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateCloudFormationChangeSetRequest
extends ServerlessApplicationRepositoryRequest
implements ToCopyableBuilder<Builder, CreateCloudFormationChangeSetRequest> {
    private final String applicationId;
    private final List<ParameterValue> parameterOverrides;
    private final String semanticVersion;
    private final String stackName;

    private CreateCloudFormationChangeSetRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.parameterOverrides = builder.parameterOverrides;
        this.semanticVersion = builder.semanticVersion;
        this.stackName = builder.stackName;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public List<ParameterValue> parameterOverrides() {
        return this.parameterOverrides;
    }

    public String semanticVersion() {
        return this.semanticVersion;
    }

    public String stackName() {
        return this.stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationChangeSetRequest)) {
            return false;
        }
        CreateCloudFormationChangeSetRequest other = (CreateCloudFormationChangeSetRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.parameterOverrides(), other.parameterOverrides()) && Objects.equals(this.semanticVersion(), other.semanticVersion()) && Objects.equals(this.stackName(), other.stackName());
    }

    public String toString() {
        return ToString.builder((String)"CreateCloudFormationChangeSetRequest").add("ApplicationId", (Object)this.applicationId()).add("ParameterOverrides", this.parameterOverrides()).add("SemanticVersion", (Object)this.semanticVersion()).add("StackName", (Object)this.stackName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "ParameterOverrides": {
                return Optional.of(clazz.cast(this.parameterOverrides()));
            }
            case "SemanticVersion": {
                return Optional.of(clazz.cast(this.semanticVersion()));
            }
            case "StackName": {
                return Optional.of(clazz.cast(this.stackName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private List<ParameterValue> parameterOverrides;
        private String semanticVersion;
        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationChangeSetRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.parameterOverrides(model.parameterOverrides);
            this.semanticVersion(model.semanticVersion);
            this.stackName(model.stackName);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final Collection<ParameterValue.Builder> getParameterOverrides() {
            return this.parameterOverrides != null ? (Collection)this.parameterOverrides.stream().map(ParameterValue::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameterOverrides(Collection<ParameterValue> parameterOverrides) {
            this.parameterOverrides = ListOfParameterValueCopier.copy(parameterOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(ParameterValue ... parameterOverrides) {
            this.parameterOverrides(Arrays.asList(parameterOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameterOverrides(Consumer<ParameterValue.Builder> ... parameterOverrides) {
            this.parameterOverrides(Stream.of(parameterOverrides).map(c -> (ParameterValue)((ParameterValue.Builder)ParameterValue.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParameterOverrides(Collection<ParameterValue.BuilderImpl> parameterOverrides) {
            this.parameterOverrides = ListOfParameterValueCopier.copyFromBuilder(parameterOverrides);
        }

        public final String getSemanticVersion() {
            return this.semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudFormationChangeSetRequest build() {
            return new CreateCloudFormationChangeSetRequest(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryRequest.Builder,
    CopyableBuilder<Builder, CreateCloudFormationChangeSetRequest> {
        public Builder applicationId(String var1);

        public Builder parameterOverrides(Collection<ParameterValue> var1);

        public Builder parameterOverrides(ParameterValue ... var1);

        public Builder parameterOverrides(Consumer<ParameterValue.Builder> ... var1);

        public Builder semanticVersion(String var1);

        public Builder stackName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

