/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOf__stringCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ServerlessApplicationRepositoryResponse;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.Version;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateApplicationResponse
extends ServerlessApplicationRepositoryResponse
implements ToCopyableBuilder<Builder, CreateApplicationResponse> {
    private final String applicationId;
    private final String author;
    private final String creationTime;
    private final String description;
    private final List<String> labels;
    private final String licenseUrl;
    private final String name;
    private final String readmeUrl;
    private final String spdxLicenseId;
    private final Version version;

    private CreateApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.author = builder.author;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.labels = builder.labels;
        this.licenseUrl = builder.licenseUrl;
        this.name = builder.name;
        this.readmeUrl = builder.readmeUrl;
        this.spdxLicenseId = builder.spdxLicenseId;
        this.version = builder.version;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String author() {
        return this.author;
    }

    public String creationTime() {
        return this.creationTime;
    }

    public String description() {
        return this.description;
    }

    public List<String> labels() {
        return this.labels;
    }

    public String licenseUrl() {
        return this.licenseUrl;
    }

    public String name() {
        return this.name;
    }

    public String readmeUrl() {
        return this.readmeUrl;
    }

    public String spdxLicenseId() {
        return this.spdxLicenseId;
    }

    public Version version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.labels());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.spdxLicenseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationResponse)) {
            return false;
        }
        CreateApplicationResponse other = (CreateApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.labels(), other.labels()) && Objects.equals(this.licenseUrl(), other.licenseUrl()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.readmeUrl(), other.readmeUrl()) && Objects.equals(this.spdxLicenseId(), other.spdxLicenseId()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"CreateApplicationResponse").add("ApplicationId", (Object)this.applicationId()).add("Author", (Object)this.author()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Labels", this.labels()).add("LicenseUrl", (Object)this.licenseUrl()).add("Name", (Object)this.name()).add("ReadmeUrl", (Object)this.readmeUrl()).add("SpdxLicenseId", (Object)this.spdxLicenseId()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.of(clazz.cast(this.applicationId()));
            }
            case "Author": {
                return Optional.of(clazz.cast(this.author()));
            }
            case "CreationTime": {
                return Optional.of(clazz.cast(this.creationTime()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Labels": {
                return Optional.of(clazz.cast(this.labels()));
            }
            case "LicenseUrl": {
                return Optional.of(clazz.cast(this.licenseUrl()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "ReadmeUrl": {
                return Optional.of(clazz.cast(this.readmeUrl()));
            }
            case "SpdxLicenseId": {
                return Optional.of(clazz.cast(this.spdxLicenseId()));
            }
            case "Version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServerlessApplicationRepositoryResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String author;
        private String creationTime;
        private String description;
        private List<String> labels;
        private String licenseUrl;
        private String name;
        private String readmeUrl;
        private String spdxLicenseId;
        private Version version;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.author(model.author);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.labels(model.labels);
            this.licenseUrl(model.licenseUrl);
            this.name(model.name);
            this.readmeUrl(model.readmeUrl);
            this.spdxLicenseId(model.spdxLicenseId);
            this.version(model.version);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getAuthor() {
            return this.author;
        }

        @Override
        public final Builder author(String author) {
            this.author = author;
            return this;
        }

        public final void setAuthor(String author) {
            this.author = author;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getLabels() {
            return this.labels;
        }

        @Override
        public final Builder labels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labels(String ... labels) {
            this.labels(Arrays.asList(labels));
            return this;
        }

        public final void setLabels(Collection<String> labels) {
            this.labels = ListOf__stringCopier.copy(labels);
        }

        public final String getLicenseUrl() {
            return this.licenseUrl;
        }

        @Override
        public final Builder licenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
            return this;
        }

        public final void setLicenseUrl(String licenseUrl) {
            this.licenseUrl = licenseUrl;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getReadmeUrl() {
            return this.readmeUrl;
        }

        @Override
        public final Builder readmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
            return this;
        }

        public final void setReadmeUrl(String readmeUrl) {
            this.readmeUrl = readmeUrl;
        }

        public final String getSpdxLicenseId() {
            return this.spdxLicenseId;
        }

        @Override
        public final Builder spdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
            return this;
        }

        public final void setSpdxLicenseId(String spdxLicenseId) {
            this.spdxLicenseId = spdxLicenseId;
        }

        public final Version.Builder getVersion() {
            return this.version != null ? this.version.toBuilder() : null;
        }

        @Override
        public final Builder version(Version version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Version.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public CreateApplicationResponse build() {
            return new CreateApplicationResponse(this);
        }
    }

    public static interface Builder
    extends ServerlessApplicationRepositoryResponse.Builder,
    CopyableBuilder<Builder, CreateApplicationResponse> {
        public Builder applicationId(String var1);

        public Builder author(String var1);

        public Builder creationTime(String var1);

        public Builder description(String var1);

        public Builder labels(Collection<String> var1);

        public Builder labels(String ... var1);

        public Builder licenseUrl(String var1);

        public Builder name(String var1);

        public Builder readmeUrl(String var1);

        public Builder spdxLicenseId(String var1);

        public Builder version(Version var1);

        default public Builder version(Consumer<Version.Builder> version) {
            return this.version((Version)((Version.Builder)Version.builder().apply(version)).build());
        }
    }
}

