/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.serverlessapplicationrepository.model.ListOf__stringCopier;
import software.amazon.awssdk.services.serverlessapplicationrepository.transform.ApplicationPolicyStatementMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ApplicationPolicyStatement
implements StructuredPojo,
ToCopyableBuilder<Builder, ApplicationPolicyStatement> {
    private final List<String> actions;
    private final List<String> principals;
    private final String statementId;

    private ApplicationPolicyStatement(BuilderImpl builder) {
        this.actions = builder.actions;
        this.principals = builder.principals;
        this.statementId = builder.statementId;
    }

    public List<String> actions() {
        return this.actions;
    }

    public List<String> principals() {
        return this.principals;
    }

    public String statementId() {
        return this.statementId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.principals());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicyStatement)) {
            return false;
        }
        ApplicationPolicyStatement other = (ApplicationPolicyStatement)obj;
        return Objects.equals(this.actions(), other.actions()) && Objects.equals(this.principals(), other.principals()) && Objects.equals(this.statementId(), other.statementId());
    }

    public String toString() {
        return ToString.builder((String)"ApplicationPolicyStatement").add("Actions", this.actions()).add("Principals", this.principals()).add("StatementId", (Object)this.statementId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "Principals": {
                return Optional.of(clazz.cast(this.principals()));
            }
            case "StatementId": {
                return Optional.of(clazz.cast(this.statementId()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ApplicationPolicyStatementMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actions;
        private List<String> principals;
        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicyStatement model) {
            this.actions(model.actions);
            this.principals(model.principals);
            this.statementId(model.statementId);
        }

        public final Collection<String> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ListOf__stringCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ListOf__stringCopier.copy(actions);
        }

        public final Collection<String> getPrincipals() {
            return this.principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = ListOf__stringCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String ... principals) {
            this.principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = ListOf__stringCopier.copy(principals);
        }

        public final String getStatementId() {
            return this.statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        public ApplicationPolicyStatement build() {
            return new ApplicationPolicyStatement(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ApplicationPolicyStatement> {
        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder principals(Collection<String> var1);

        public Builder principals(String ... var1);

        public Builder statementId(String var1);
    }
}

